/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.util.xstream;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import com.thoughtworks.xstream.io.xml.XppReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.MessageTransformerSupport;

public class XStreamMessageTransformer
extends MessageTransformerSupport {
    protected MessageTransform transformType;
    private XStream xStream;

    public XStreamMessageTransformer() {
        this(MessageTransform.XML);
    }

    public XStreamMessageTransformer(MessageTransform transformType) {
        this.transformType = transformType;
    }

    public Message consumerTransform(Session session, MessageConsumer consumer, Message message) throws JMSException {
        switch (this.transformType) {
            case XML: {
                return message instanceof TextMessage ? this.textToObject(session, (TextMessage)message) : message;
            }
            case OBJECT: {
                return message instanceof ObjectMessage ? this.objectToText(session, (ObjectMessage)message) : message;
            }
            case ADAPTIVE: {
                return message instanceof TextMessage ? this.textToObject(session, (TextMessage)message) : (message instanceof ObjectMessage ? this.objectToText(session, (ObjectMessage)message) : message);
            }
        }
        return message;
    }

    public Message producerTransform(Session session, MessageProducer producer, Message message) throws JMSException {
        switch (this.transformType) {
            case XML: {
                return message instanceof ObjectMessage ? this.objectToText(session, (ObjectMessage)message) : message;
            }
            case OBJECT: {
                return message instanceof TextMessage ? this.textToObject(session, (TextMessage)message) : message;
            }
            case ADAPTIVE: {
                return message instanceof TextMessage ? this.textToObject(session, (TextMessage)message) : (message instanceof ObjectMessage ? this.objectToText(session, (ObjectMessage)message) : message);
            }
        }
        return message;
    }

    public XStream getXStream() {
        if (this.xStream == null) {
            this.xStream = this.createXStream();
        }
        return this.xStream;
    }

    public void setXStream(XStream xStream) {
        this.xStream = xStream;
    }

    protected XStream createXStream() {
        return new XStream();
    }

    public MessageTransform getTransformType() {
        return this.transformType;
    }

    public void setTransformType(MessageTransform transformType) {
        this.transformType = transformType;
    }

    protected ObjectMessage textToObject(Session session, TextMessage textMessage) throws JMSException {
        Object object = this.unmarshall(session, textMessage);
        if (object instanceof Serializable) {
            ObjectMessage answer = session.createObjectMessage((Serializable)object);
            this.copyProperties(textMessage, answer);
            return answer;
        }
        throw new JMSException("Object is not serializable: " + object);
    }

    protected TextMessage objectToText(Session session, ObjectMessage objectMessage) throws JMSException {
        TextMessage answer = session.createTextMessage(this.marshall(session, objectMessage));
        this.copyProperties(objectMessage, answer);
        return answer;
    }

    protected String marshall(Session session, ObjectMessage objectMessage) throws JMSException {
        Serializable object = objectMessage.getObject();
        StringWriter buffer = new StringWriter();
        PrettyPrintWriter out = new PrettyPrintWriter((Writer)buffer);
        this.getXStream().marshal((Object)object, (HierarchicalStreamWriter)out);
        return buffer.toString();
    }

    protected Object unmarshall(Session session, TextMessage textMessage) throws JMSException {
        XppReader in = new XppReader((Reader)new StringReader(textMessage.getText()));
        return this.getXStream().unmarshal((HierarchicalStreamReader)in);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MessageTransform {
        XML,
        OBJECT,
        ADAPTIVE;

    }
}

