/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.ha;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.configuration.Configuration;

public final class HAConfiguration {
    public static final String ATLAS_SERVER_ZK_ROOT_DEFAULT = "/apache_atlas";
    public static final String ATLAS_SERVER_HA_PREFIX = "atlas.server.ha.";
    public static final String ZOOKEEPER_PREFIX = "zookeeper.";
    public static final String ATLAS_SERVER_HA_ZK_ROOT_KEY = "atlas.server.ha.zookeeper.zkroot";
    public static final String ATLAS_SERVER_HA_ENABLED_KEY = "atlas.server.ha.enabled";
    public static final String ATLAS_SERVER_ADDRESS_PREFIX = "atlas.server.address.";
    public static final String ATLAS_SERVER_IDS = "atlas.server.ids";
    public static final String HA_ZOOKEEPER_CONNECT = "atlas.server.ha.zookeeper.connect";
    public static final int DEFAULT_ZOOKEEPER_CONNECT_SLEEPTIME_MILLIS = 1000;
    public static final String HA_ZOOKEEPER_RETRY_SLEEPTIME_MILLIS = "atlas.server.ha.zookeeper.retry.sleeptime.ms";
    public static final String HA_ZOOKEEPER_NUM_RETRIES = "atlas.server.ha.zookeeper.num.retries";
    public static final int DEFAULT_ZOOKEEPER_CONNECT_NUM_RETRIES = 3;
    public static final String HA_ZOOKEEPER_SESSION_TIMEOUT_MS = "atlas.server.ha.zookeeper.session.timeout.ms";
    public static final int DEFAULT_ZOOKEEPER_SESSION_TIMEOUT_MILLIS = 20000;
    public static final String HA_ZOOKEEPER_ACL = "atlas.server.ha.zookeeper.acl";
    public static final String HA_ZOOKEEPER_AUTH = "atlas.server.ha.zookeeper.auth";

    private HAConfiguration() {
    }

    public static boolean isHAEnabled(Configuration configuration) {
        return configuration.getBoolean(ATLAS_SERVER_HA_ENABLED_KEY, false);
    }

    public static String getBoundAddressForId(Configuration configuration, String serverId) {
        String hostPort = configuration.getString(ATLAS_SERVER_ADDRESS_PREFIX + serverId);
        boolean isSecure = configuration.getBoolean("atlas.enableTLS");
        String protocol = isSecure ? "https://" : "http://";
        return protocol + hostPort;
    }

    public static List<String> getServerInstances(Configuration configuration) {
        String[] serverIds = configuration.getStringArray(ATLAS_SERVER_IDS);
        ArrayList<String> serverInstances = new ArrayList<String>(serverIds.length);
        for (String serverId : serverIds) {
            serverInstances.add(HAConfiguration.getBoundAddressForId(configuration, serverId));
        }
        return serverInstances;
    }

    public static ZookeeperProperties getZookeeperProperties(Configuration configuration) {
        String zookeeperConnectString = configuration.getString("atlas.kafka.zookeeper.connect");
        if (configuration.containsKey(HA_ZOOKEEPER_CONNECT)) {
            zookeeperConnectString = configuration.getString(HA_ZOOKEEPER_CONNECT);
        }
        String zkRoot = configuration.getString(ATLAS_SERVER_HA_ZK_ROOT_KEY, ATLAS_SERVER_ZK_ROOT_DEFAULT);
        int retriesSleepTimeMillis = configuration.getInt(HA_ZOOKEEPER_RETRY_SLEEPTIME_MILLIS, 1000);
        int numRetries = configuration.getInt(HA_ZOOKEEPER_NUM_RETRIES, 3);
        int sessionTimeout = configuration.getInt(HA_ZOOKEEPER_SESSION_TIMEOUT_MS, 20000);
        String acl = configuration.getString(HA_ZOOKEEPER_ACL);
        String auth = configuration.getString(HA_ZOOKEEPER_AUTH);
        return new ZookeeperProperties(zookeeperConnectString, zkRoot, retriesSleepTimeMillis, numRetries, sessionTimeout, acl, auth);
    }

    public static class ZookeeperProperties {
        private String connectString;
        private String zkRoot;
        private int retriesSleepTimeMillis;
        private int numRetries;
        private int sessionTimeout;
        private String acl;
        private String auth;

        public ZookeeperProperties(String connectString, String zkRoot, int retriesSleepTimeMillis, int numRetries, int sessionTimeout, String acl, String auth) {
            this.connectString = connectString;
            this.zkRoot = zkRoot;
            this.retriesSleepTimeMillis = retriesSleepTimeMillis;
            this.numRetries = numRetries;
            this.sessionTimeout = sessionTimeout;
            this.acl = acl;
            this.auth = auth;
        }

        public String getConnectString() {
            return this.connectString;
        }

        public int getRetriesSleepTimeMillis() {
            return this.retriesSleepTimeMillis;
        }

        public int getNumRetries() {
            return this.numRetries;
        }

        public int getSessionTimeout() {
            return this.sessionTimeout;
        }

        public String getAcl() {
            return this.acl;
        }

        public String getAuth() {
            return this.auth;
        }

        public String getZkRoot() {
            return this.zkRoot;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ZookeeperProperties that = (ZookeeperProperties)o;
            if (this.retriesSleepTimeMillis != that.retriesSleepTimeMillis) {
                return false;
            }
            if (this.numRetries != that.numRetries) {
                return false;
            }
            if (this.sessionTimeout != that.sessionTimeout) {
                return false;
            }
            if (!this.connectString.equals(that.connectString)) {
                return false;
            }
            if (!this.zkRoot.equals(that.zkRoot)) {
                return false;
            }
            if (this.acl != null ? !this.acl.equals(that.acl) : that.acl != null) {
                return false;
            }
            return !(this.auth == null ? that.auth != null : !this.auth.equals(that.auth));
        }

        public int hashCode() {
            int result = this.connectString.hashCode();
            result = 31 * result + this.zkRoot.hashCode();
            result = 31 * result + this.retriesSleepTimeMillis;
            result = 31 * result + this.numRetries;
            result = 31 * result + this.sessionTimeout;
            result = 31 * result + (this.acl != null ? this.acl.hashCode() : 0);
            result = 31 * result + (this.auth != null ? this.auth.hashCode() : 0);
            return result;
        }

        public boolean hasAcl() {
            return this.getAcl() != null;
        }

        public boolean hasAuth() {
            return this.getAuth() != null;
        }
    }
}

