/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.utils;

import java.util.Arrays;
import java.util.Collection;

public final class ParamChecker {
    private ParamChecker() {
    }

    public static <T> T notNull(T obj, String name) {
        if (obj == null) {
            throw new IllegalArgumentException(name + " cannot be null");
        }
        return obj;
    }

    public static <T> Collection<T> notNullElements(Collection<T> list, String name) {
        ParamChecker.notEmpty(list, name);
        for (T ele : list) {
            ParamChecker.notNull(ele, String.format("Collection %s element %s", name, ele));
        }
        return list;
    }

    public static <T> T[] notNullElements(T[] array, String name) {
        ParamChecker.notEmpty(Arrays.asList(array), name);
        for (T ele : array) {
            ParamChecker.notNull(ele, String.format("Collection %s element %s", name, ele));
        }
        return array;
    }

    public static <T> Collection<T> notEmpty(Collection<T> list, String name) {
        ParamChecker.notNull(list, name);
        if (list.isEmpty()) {
            throw new IllegalArgumentException(String.format("Collection %s is empty", name));
        }
        return list;
    }

    public static String notEmpty(String value, String name) {
        return ParamChecker.notEmpty(value, name, null);
    }

    public static String notEmptyIfNotNull(String value, String name) {
        return ParamChecker.notEmptyIfNotNull(value, name, null);
    }

    public static String notEmptyIfNotNull(String value, String name, String info) {
        if (value == null) {
            return value;
        }
        if (value.trim().length() == 0) {
            throw new IllegalArgumentException(name + " cannot be empty" + (info == null ? "" : ", " + info));
        }
        return value.trim();
    }

    public static String notEmpty(String value, String name, String info) {
        if (value == null) {
            throw new IllegalArgumentException(name + " cannot be null" + (info == null ? "" : ", " + info));
        }
        return ParamChecker.notEmptyIfNotNull(value, name, info);
    }

    public static Collection<String> notEmptyElements(Collection<String> list, String name) {
        ParamChecker.notEmpty(list, name);
        for (String ele : list) {
            ParamChecker.notEmpty(ele, String.format("list %s element %s", name, ele));
        }
        return list;
    }

    public static void lessThan(short value, short maxValue, String name) {
        if (value <= 0) {
            throw new IllegalArgumentException(name + " should be > 0, current value " + value);
        }
        if (value > maxValue) {
            throw new IllegalArgumentException(name + " should be <= " + maxValue + ", current value " + value);
        }
    }
}

