/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.entitytransform;

import java.util.Arrays;
import java.util.List;
import org.apache.atlas.entitytransform.AtlasEntityTransformer;
import org.apache.atlas.entitytransform.BaseEntityHandler;
import org.apache.atlas.entitytransform.EntityAttribute;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.commons.lang.StringUtils;

public class HiveTableEntityHandler
extends BaseEntityHandler {
    static final List<String> CUSTOM_TRANSFORM_ATTRIBUTES = Arrays.asList("hive_db.name", "hive_table.name", "hive_db.clusterName");

    public HiveTableEntityHandler(List<AtlasEntityTransformer> transformers) {
        super(transformers);
    }

    @Override
    public BaseEntityHandler.AtlasTransformableEntity getTransformableEntity(AtlasEntity entity) {
        return this.isHiveTableEntity(entity) ? new HiveTableEntity(entity) : null;
    }

    private boolean isHiveTableEntity(AtlasEntity entity) {
        return StringUtils.equals((String)entity.getTypeName(), (String)"hive_table");
    }

    private static class HiveTableEntity
    extends BaseEntityHandler.AtlasTransformableEntity {
        private String databaseName;
        private String tableName;
        private String clusterName;
        private boolean isCustomAttributeUpdated = false;

        public HiveTableEntity(AtlasEntity entity) {
            super(entity);
            this.tableName = (String)entity.getAttribute("name");
            String qualifiedName = (String)entity.getAttribute("qualifiedName");
            if (qualifiedName != null) {
                int databaseSeparatorIdx = qualifiedName.indexOf(46);
                int clusterSeparatorIdx = qualifiedName.lastIndexOf(64);
                this.databaseName = databaseSeparatorIdx != -1 ? qualifiedName.substring(0, databaseSeparatorIdx) : "";
                this.clusterName = clusterSeparatorIdx != -1 ? qualifiedName.substring(clusterSeparatorIdx + 1) : "";
            } else {
                this.databaseName = "";
                this.clusterName = "";
            }
        }

        @Override
        public Object getAttribute(EntityAttribute attribute) {
            switch (attribute.getAttributeKey()) {
                case "hive_table.name": {
                    return this.tableName;
                }
                case "hive_db.name": {
                    return this.databaseName;
                }
                case "hive_db.clusterName": {
                    return this.clusterName;
                }
            }
            return super.getAttribute(attribute);
        }

        @Override
        public void setAttribute(EntityAttribute attribute, String attributeValue) {
            switch (attribute.getAttributeKey()) {
                case "hive_table.name": {
                    this.tableName = attributeValue;
                    this.isCustomAttributeUpdated = true;
                    break;
                }
                case "hive_db.name": {
                    this.databaseName = attributeValue;
                    this.isCustomAttributeUpdated = true;
                    break;
                }
                case "hive_db.clusterName": {
                    this.clusterName = attributeValue;
                    this.isCustomAttributeUpdated = true;
                    break;
                }
                default: {
                    super.setAttribute(attribute, attributeValue);
                }
            }
        }

        @Override
        public void transformComplete() {
            if (this.isCustomAttributeUpdated) {
                this.entity.setAttribute("name", this.tableName);
                this.entity.setAttribute("qualifiedName", this.toQualifiedName());
            }
        }

        private String toQualifiedName() {
            return String.format("%s.%s@%s", this.databaseName, this.tableName, this.clusterName);
        }
    }
}

