/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.model.notification;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.atlas.model.instance.AtlasEntityHeader;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonSerialize(include=JsonSerialize.Inclusion.ALWAYS)
@JsonIgnoreProperties(ignoreUnknown=true)
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class EntityNotification
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected EntityNotificationType type;

    public EntityNotification() {
        this.type = EntityNotificationType.ENTITY_NOTIFICATION_V1;
    }

    public EntityNotification(EntityNotificationType type) {
        this.type = type;
    }

    public EntityNotificationType getType() {
        return this.type;
    }

    public void setType(EntityNotificationType type) {
        this.type = type;
    }

    public void normalize() {
    }

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }

    public StringBuilder toString(StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        sb.append("EntityNotification{");
        sb.append("type=").append((Object)this.type);
        sb.append("}");
        return sb;
    }

    @JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    public static class EntityNotificationV2
    extends EntityNotification
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private AtlasEntityHeader entity;
        private OperationType operationType;
        private long eventTime;

        public EntityNotificationV2() {
            this(null, null, System.currentTimeMillis());
        }

        public EntityNotificationV2(AtlasEntityHeader entity, OperationType operationType) {
            this(entity, operationType, System.currentTimeMillis());
        }

        public EntityNotificationV2(AtlasEntityHeader entity, OperationType operationType, long eventTime) {
            super(EntityNotificationType.ENTITY_NOTIFICATION_V2);
            this.setEntity(entity);
            this.setOperationType(operationType);
            this.setEventTime(eventTime);
        }

        public AtlasEntityHeader getEntity() {
            return this.entity;
        }

        public void setEntity(AtlasEntityHeader entity) {
            this.entity = entity;
        }

        public OperationType getOperationType() {
            return this.operationType;
        }

        public void setOperationType(OperationType operationType) {
            this.operationType = operationType;
        }

        public long getEventTime() {
            return this.eventTime;
        }

        public void setEventTime(long eventTime) {
            this.eventTime = eventTime;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EntityNotificationV2 that = (EntityNotificationV2)o;
            return Objects.equals((Object)this.type, (Object)that.type) && Objects.equals(this.entity, that.entity) && this.operationType == that.operationType;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.entity, this.operationType});
        }

        @Override
        public StringBuilder toString(StringBuilder sb) {
            if (sb == null) {
                sb = new StringBuilder();
            }
            sb.append("EntityNotificationV1{");
            super.toString(sb);
            sb.append(", entity=");
            if (this.entity != null) {
                this.entity.toString(sb);
            } else {
                sb.append(this.entity);
            }
            sb.append(", operationType=").append((Object)this.operationType);
            sb.append(", eventTime=").append(this.eventTime);
            sb.append("}");
            return sb;
        }

        public static enum OperationType {
            ENTITY_CREATE,
            ENTITY_UPDATE,
            ENTITY_DELETE,
            CLASSIFICATION_ADD,
            CLASSIFICATION_DELETE,
            CLASSIFICATION_UPDATE;

        }
    }

    public static enum EntityNotificationType {
        ENTITY_NOTIFICATION_V1,
        ENTITY_NOTIFICATION_V2;

    }
}

