/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.type;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.TypeCategory;
import org.apache.atlas.model.typedef.AtlasBaseTypeDef;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.utils.AtlasJson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AtlasType {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasType.class);
    private final String typeName;
    private final TypeCategory typeCategory;
    private final String serviceType;

    protected AtlasType(AtlasBaseTypeDef typeDef) {
        this(typeDef.getName(), typeDef.getCategory(), typeDef.getServiceType());
    }

    protected AtlasType(String typeName, TypeCategory typeCategory, String serviceType) {
        this.typeName = typeName;
        this.typeCategory = typeCategory;
        this.serviceType = serviceType;
    }

    void resolveReferences(AtlasTypeRegistry typeRegistry) throws AtlasBaseException {
    }

    void resolveReferencesPhase2(AtlasTypeRegistry typeRegistry) throws AtlasBaseException {
    }

    void resolveReferencesPhase3(AtlasTypeRegistry typeRegistry) throws AtlasBaseException {
    }

    public String getTypeName() {
        return this.typeName;
    }

    public TypeCategory getTypeCategory() {
        return this.typeCategory;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public abstract Object createDefaultValue();

    public Object createOptionalDefaultValue() {
        return this.createDefaultValue();
    }

    public Object createDefaultValue(Object val) {
        return val == null ? this.createDefaultValue() : this.getNormalizedValue(val);
    }

    public abstract boolean isValidValue(Object var1);

    public boolean areEqualValues(Object val1, Object val2, Map<String, String> guidAssignments) {
        Object normalizedVal2;
        Object normalizedVal1;
        boolean ret = val1 == null ? val2 == null : (val2 == null ? false : ((normalizedVal1 = this.getNormalizedValue(val1)) == null ? false : ((normalizedVal2 = this.getNormalizedValue(val2)) == null ? false : Objects.equals(normalizedVal1, normalizedVal2))));
        return ret;
    }

    public abstract Object getNormalizedValue(Object var1);

    public boolean validateValue(Object obj, String objName, List<String> messages) {
        boolean ret = this.isValidValue(obj);
        if (!ret) {
            messages.add(objName + "=" + obj + ": invalid value for type " + this.getTypeName());
        }
        return ret;
    }

    public boolean isValidValueForUpdate(Object obj) {
        return this.isValidValue(obj);
    }

    public Object getNormalizedValueForUpdate(Object obj) {
        return this.getNormalizedValue(obj);
    }

    public boolean validateValueForUpdate(Object obj, String objName, List<String> messages) {
        return this.validateValue(obj, objName, messages);
    }

    public AtlasType getTypeForAttribute() {
        return this;
    }

    public static String toJson(Object obj) {
        return AtlasJson.toJson(obj);
    }

    public static <T> T fromJson(String jsonStr, Class<T> type) {
        return AtlasJson.fromJson(jsonStr, type);
    }

    public static String toV1Json(Object obj) {
        return AtlasJson.toV1Json(obj);
    }

    public static <T> T fromV1Json(String jsonStr, Class<T> type) {
        return AtlasJson.fromV1Json(jsonStr, type);
    }

    public static <T> T fromV1Json(String jsonStr, TypeReference<T> type) {
        return AtlasJson.fromV1Json(jsonStr, type);
    }
}

