/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.v1.model.typedef;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.atlas.v1.model.typedef.AttributeDefinition;
import org.apache.atlas.v1.model.typedef.StructTypeDefinition;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class HierarchicalTypeDefinition
extends StructTypeDefinition
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String hierarchicalMetaTypeName = "org.apache.atlas.typesystem.types.TraitType";
    private Set<String> superTypes;

    public HierarchicalTypeDefinition() {
    }

    public HierarchicalTypeDefinition(String typeName, String typeDescription, String typeVersion, List<AttributeDefinition> attributeDefinitions, String hierarchicalMetaTypeName, Set<String> superTypes) {
        super(typeName, typeDescription, typeVersion, attributeDefinitions);
        this.hierarchicalMetaTypeName = hierarchicalMetaTypeName;
        this.superTypes = superTypes;
    }

    public String getHierarchicalMetaTypeName() {
        return this.hierarchicalMetaTypeName;
    }

    public void setHierarchicalMetaTypeName(String hierarchicalMetaTypeName) {
        this.hierarchicalMetaTypeName = hierarchicalMetaTypeName;
    }

    public Set<String> getSuperTypes() {
        return this.superTypes;
    }

    public void setSuperTypes(Set<String> superTypes) {
        this.superTypes = superTypes;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass() || !super.equals(o)) {
            return false;
        }
        HierarchicalTypeDefinition that = (HierarchicalTypeDefinition)o;
        return Objects.equals(this.superTypes, that.superTypes) && Objects.equals(this.hierarchicalMetaTypeName, that.hierarchicalMetaTypeName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.superTypes, this.hierarchicalMetaTypeName);
    }
}

