/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.deployment;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.axis2.AxisFault;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisConfigurator;
import org.apache.axis2.util.Loader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class URLBasedAxisConfigurator
extends DeploymentEngine
implements AxisConfigurator {
    private static final Log log = LogFactory.getLog(URLBasedAxisConfigurator.class);
    private URL axis2xml;
    private URL repository;

    public URLBasedAxisConfigurator(URL axis2xml, URL repository) throws AxisFault {
        this.axis2xml = axis2xml;
        this.repository = repository;
    }

    @Override
    public AxisConfiguration getAxisConfiguration() throws AxisFault {
        try {
            InputStream axis2xmlStream = this.axis2xml == null ? Loader.getResourceAsStream("org/apache/axis2/deployment/axis2_default.xml") : this.axis2xml.openStream();
            this.axisConfig = this.populateAxisConfiguration(axis2xmlStream);
            if (this.repository == null) {
                Parameter axis2repoPara = this.axisConfig.getParameter("repository");
                if (axis2repoPara != null) {
                    String repoValue = (String)axis2repoPara.getValue();
                    if (repoValue != null && !"".equals(repoValue.trim())) {
                        if (repoValue.startsWith("file:/")) {
                            this.loadRepository(repoValue);
                        } else {
                            this.loadRepositoryFromURL(new URL(repoValue));
                        }
                    }
                } else {
                    log.info((Object)"No repository found , module will be loaded from classpath");
                    this.loadFromClassPath();
                }
            } else {
                this.loadRepositoryFromURL(this.repository);
            }
        }
        catch (IOException e) {
            throw AxisFault.makeFault(e);
        }
        this.axisConfig.setConfigurator(this);
        return this.axisConfig;
    }

    @Override
    public void loadServices() {
        try {
            if (this.repository == null) {
                String repoValue;
                Parameter axis2repoPara = this.axisConfig.getParameter("repository");
                if (axis2repoPara != null && (repoValue = (String)axis2repoPara.getValue()) != null && !"".equals(repoValue.trim())) {
                    if (repoValue.startsWith("file://")) {
                        super.loadServices();
                    } else {
                        this.loadServicesFromUrl(new URL(repoValue));
                    }
                }
            } else {
                this.loadServicesFromUrl(this.repository);
            }
        }
        catch (MalformedURLException e) {
            log.info((Object)e);
        }
    }

    @Override
    public void engageGlobalModules() throws AxisFault {
        this.engageModules();
    }
}

