/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test;

import com.google.common.base.Preconditions;
import java.lang.reflect.AnnotatedElement;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.function.UnaryOperator;
import org.apache.calcite.avatica.util.Casing;
import org.apache.calcite.avatica.util.Quoting;
import org.apache.calcite.config.Lex;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlCollation;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.StringAndPos;
import org.apache.calcite.sql.test.AbstractSqlTester;
import org.apache.calcite.sql.test.SqlTestFactory;
import org.apache.calcite.sql.test.SqlTester;
import org.apache.calcite.sql.test.SqlValidatorTester;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.calcite.sql.validate.SqlConformanceEnum;
import org.apache.calcite.sql.validate.SqlMonotonicity;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.test.catalog.MockCatalogReaderExtended;
import org.apache.calcite.testlib.annotations.WithLex;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.support.AnnotationSupport;

public class SqlValidatorTestCase {
    private static final SqlTestFactory EXTENDED_TEST_FACTORY = SqlTestFactory.INSTANCE.withCatalogReader(MockCatalogReaderExtended::new);
    static final SqlTester EXTENDED_CATALOG_TESTER = new SqlValidatorTester(EXTENDED_TEST_FACTORY);
    static final SqlTester EXTENDED_CATALOG_TESTER_2003 = new SqlValidatorTester(EXTENDED_TEST_FACTORY).withConformance((SqlConformance)SqlConformanceEnum.PRAGMATIC_2003);
    static final SqlTester EXTENDED_CATALOG_TESTER_LENIENT = new SqlValidatorTester(EXTENDED_TEST_FACTORY).withConformance((SqlConformance)SqlConformanceEnum.LENIENT);
    protected SqlTester tester = this.getTester();

    public SqlTester getTester() {
        return new SqlValidatorTester(SqlTestFactory.INSTANCE);
    }

    public final Sql sql(String sql) {
        return new Sql(this.tester, StringAndPos.of((String)sql), true, false);
    }

    public final Sql expr(String sql) {
        return new Sql(this.tester, StringAndPos.of((String)sql), false, false);
    }

    public final Sql wholeExpr(String sql) {
        return this.expr(sql).withWhole(true);
    }

    public final Sql winSql(String sql) {
        return this.sql(sql);
    }

    public final Sql win(String sql) {
        return this.sql("select * from emp " + sql);
    }

    public Sql winExp(String sql) {
        return this.winSql("select " + sql + " from emp window w as (order by deptno)");
    }

    public Sql winExp2(String sql) {
        return this.winSql("select " + sql + " from emp");
    }

    public static class LexConfiguration
    implements BeforeEachCallback {
        public void beforeEach(ExtensionContext context) {
            context.getElement().flatMap(element -> AnnotationSupport.findAnnotation((AnnotatedElement)element, WithLex.class)).ifPresent(lex -> {
                SqlValidatorTestCase tc = (SqlValidatorTestCase)context.getTestInstance().get();
                SqlTester tester = tc.tester;
                tc.tester = tester = tester.withLex(lex.value());
            });
        }
    }

    static class Sql {
        private final SqlTester tester;
        private final StringAndPos sap;
        private final boolean query;
        private final boolean whole;

        Sql(SqlTester tester, StringAndPos sap, boolean query, boolean whole) {
            this.tester = tester;
            this.query = query;
            this.sap = sap;
            this.whole = whole;
        }

        Sql withTester(UnaryOperator<SqlTester> transform) {
            return new Sql((SqlTester)transform.apply(this.tester), this.sap, this.query, this.whole);
        }

        public Sql sql(String sql) {
            return new Sql(this.tester, StringAndPos.of((String)sql), true, false);
        }

        public Sql expr(String sql) {
            return new Sql(this.tester, StringAndPos.of((String)sql), false, false);
        }

        public StringAndPos toSql(boolean withCaret) {
            return this.query ? this.sap : StringAndPos.of((String)AbstractSqlTester.buildQuery(this.sap.addCarets()));
        }

        Sql withExtendedCatalog() {
            return this.withTester(tester -> EXTENDED_CATALOG_TESTER);
        }

        public Sql withQuoting(Quoting quoting) {
            return this.withTester(tester -> tester.withQuoting(quoting));
        }

        Sql withLex(Lex lex) {
            return this.withTester(tester -> tester.withLex(lex));
        }

        Sql withConformance(SqlConformance conformance) {
            return this.withTester(tester -> tester.withConformance(conformance));
        }

        Sql withTypeCoercion(boolean typeCoercion) {
            return this.withTester(tester -> tester.enableTypeCoercion(typeCoercion));
        }

        Sql withWhole(boolean whole) {
            Preconditions.checkArgument((this.sap.cursor < 0 ? 1 : 0) != 0);
            return new Sql(this.tester, StringAndPos.of((String)("^" + this.sap.sql + "^")), this.query, whole);
        }

        Sql ok() {
            this.tester.assertExceptionIsThrown(this.toSql(false), null);
            return this;
        }

        Sql fails(String expected) {
            Objects.requireNonNull(expected, "expected");
            this.tester.assertExceptionIsThrown(this.toSql(true), expected);
            return this;
        }

        Sql failsIf(boolean b, String expected) {
            if (b) {
                this.fails(expected);
            } else {
                this.ok();
            }
            return this;
        }

        public Sql type(String expectedType) {
            this.tester.checkResultType(this.sap.sql, expectedType);
            return this;
        }

        public Sql columnType(String expectedType) {
            this.tester.checkColumnType(this.toSql((boolean)false).sql, expectedType);
            return this;
        }

        public Sql monotonic(SqlMonotonicity expectedMonotonicity) {
            this.tester.checkMonotonic(this.toSql((boolean)false).sql, expectedMonotonicity);
            return this;
        }

        public Sql bindType(String bindType) {
            this.tester.check(this.sap.sql, null, parameterRowType -> MatcherAssert.assertThat((Object)parameterRowType.toString(), (Matcher)CoreMatchers.is((Object)bindType)), result -> {});
            return this;
        }

        public void charset(Charset expectedCharset) {
            this.tester.checkCharset(this.sap.sql, expectedCharset);
        }

        public void collation(String expectedCollationName, SqlCollation.Coercibility expectedCoercibility) {
            this.tester.checkCollation(this.sap.sql, expectedCollationName, expectedCoercibility);
        }

        public void intervalConv(String expected) {
            this.tester.checkIntervalConv(this.toSql((boolean)false).sql, expected);
        }

        public Sql withCaseSensitive(boolean caseSensitive) {
            return this.withTester(tester -> tester.withCaseSensitive(caseSensitive));
        }

        public Sql withOperatorTable(SqlOperatorTable operatorTable) {
            return this.withTester(tester -> tester.withOperatorTable(operatorTable));
        }

        public Sql withUnquotedCasing(Casing casing) {
            return this.withTester(tester -> tester.withUnquotedCasing(casing));
        }

        private static SqlTester addTransform(SqlTester tester, UnaryOperator<SqlValidator> after) {
            return tester.withValidatorTransform(transform -> validator -> (SqlValidator)after.apply((SqlValidator)transform.apply(validator)));
        }

        public Sql withValidatorIdentifierExpansion(boolean expansion) {
            UnaryOperator after = sqlValidator -> sqlValidator.transform(config -> config.withIdentifierExpansion(expansion));
            return this.withTester(tester -> Sql.addTransform(tester, after));
        }

        public Sql withValidatorCallRewrite(boolean rewrite) {
            UnaryOperator after = sqlValidator -> sqlValidator.transform(config -> config.withCallRewrite(rewrite));
            return this.withTester(tester -> Sql.addTransform(tester, after));
        }

        public Sql withValidatorColumnReferenceExpansion(boolean expansion) {
            UnaryOperator after = sqlValidator -> sqlValidator.transform(config -> config.withColumnReferenceExpansion(expansion));
            return this.withTester(tester -> Sql.addTransform(tester, after));
        }

        public Sql rewritesTo(String expected) {
            this.tester.checkRewrite(this.toSql((boolean)false).sql, expected);
            return this;
        }
    }

    public static interface Tester {
        public SqlNode parseQuery(String var1) throws SqlParseException;

        public SqlNode parseAndValidate(SqlValidator var1, String var2);

        public SqlValidator getValidator();

        public void assertExceptionIsThrown(StringAndPos var1, String var2);

        public RelDataType getColumnType(String var1);

        public RelDataType getResultType(String var1);

        public void checkCollation(String var1, String var2, SqlCollation.Coercibility var3);

        public void checkCharset(String var1, Charset var2);

        public void checkColumnType(String var1, String var2);

        public void checkFieldOrigin(String var1, String var2);

        public void checkRewrite(String var1, String var2);

        public void checkResultType(String var1, String var2);

        public void checkIntervalConv(String var1, String var2);

        public SqlMonotonicity getMonotonicity(String var1);

        public SqlConformance getConformance();
    }
}

