/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test.catalog;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.calcite.schema.impl.ViewTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.test.catalog.MockCatalogReader;

public class MockCatalogReaderDynamic
extends MockCatalogReader {
    public MockCatalogReaderDynamic(RelDataTypeFactory typeFactory, boolean caseSensitive) {
        super(typeFactory, caseSensitive);
    }

    @Override
    public MockCatalogReader init() {
        MockCatalogReader.MockSchema schema = new MockCatalogReader.MockSchema("SALES");
        this.registerSchema(schema);
        MockCatalogReader.MockDynamicTable nationTable = new MockCatalogReader.MockDynamicTable(schema.getCatalogName(), schema.getName(), "NATION");
        this.registerTable(nationTable);
        Supplier<MockCatalogReader.MockDynamicTable> customerTableSupplier = () -> new MockCatalogReader.MockDynamicTable(schema.getCatalogName(), schema.getName(), "CUSTOMER");
        MockCatalogReader.MockDynamicTable customerTable = customerTableSupplier.get();
        this.registerTable(customerTable);
        RelDataType intType = this.typeFactory.createSqlType(SqlTypeName.INTEGER);
        RelDataType varcharType = this.typeFactory.createSqlType(SqlTypeName.VARCHAR);
        MockCatalogReader.MockTable regionTable = MockCatalogReader.MockTable.create(this, schema, "REGION", false, 100.0);
        regionTable.addColumn("R_REGIONKEY", intType);
        regionTable.addColumn("R_NAME", varcharType);
        regionTable.addColumn("R_COMMENT", varcharType);
        this.registerTable(regionTable);
        List<String> custModifiableViewNames = Arrays.asList(schema.getCatalogName(), schema.getName(), "CUSTOMER_MODIFIABLEVIEW");
        MockCatalogReader.MockModifiableViewRelOptTable.MockViewTableMacro custModifiableViewMacro = MockCatalogReader.MockModifiableViewRelOptTable.viewMacro(this.rootSchema, "select n_name from SALES.CUSTOMER", custModifiableViewNames.subList(0, 2), Collections.singletonList(custModifiableViewNames.get(2)), true);
        TranslatableTable empModifiableView = custModifiableViewMacro.apply(Collections.emptyList());
        MockCatalogReader.MockRelViewTable mockCustViewTable = MockCatalogReader.MockRelViewTable.create((ViewTable)empModifiableView, this, custModifiableViewNames.get(0), custModifiableViewNames.get(1), custModifiableViewNames.get(2), false, 20.0, null);
        this.registerTable(mockCustViewTable);
        this.reregisterTable(customerTableSupplier.get());
        return this;
    }
}

