/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.spi;

import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.NamedNode;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.ErrorHandlerBuilderRef;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.reifier.errorhandler.ErrorHandlerReifier;
import org.apache.camel.spi.TransactedPolicy;
import org.apache.camel.spring.spi.TransactionErrorHandler;
import org.apache.camel.spring.spi.TransactionErrorHandlerBuilder;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

public class SpringTransactionPolicy
implements TransactedPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(SpringTransactionPolicy.class);
    private TransactionTemplate template;
    private String propagationBehaviorName;
    private PlatformTransactionManager transactionManager;

    public SpringTransactionPolicy() {
    }

    public SpringTransactionPolicy(TransactionTemplate template) {
        this.template = template;
    }

    public SpringTransactionPolicy(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void beforeWrap(Route route, NamedNode definition) {
    }

    public Processor wrap(Route route, Processor processor) {
        TransactionErrorHandler answer;
        ErrorHandlerBuilderRef builderRef;
        String ref;
        RouteDefinition routeDefinition = (RouteDefinition)route.getRoute();
        ErrorHandlerBuilder builder = (ErrorHandlerBuilder)routeDefinition.getErrorHandlerFactory();
        if (builder instanceof ErrorHandlerBuilderRef && ErrorHandlerReifier.isErrorHandlerFactoryConfigured((String)(ref = (builderRef = (ErrorHandlerBuilderRef)builder).getRef()))) {
            LOG.debug("Looking up ErrorHandlerBuilder with ref: {}", (Object)ref);
            builder = (ErrorHandlerBuilder)ErrorHandlerReifier.lookupErrorHandlerFactory((Route)route, (String)ref);
        }
        if (builder != null && builder.supportTransacted()) {
            LOG.debug("The ErrorHandlerBuilder configured is already a TransactionErrorHandlerBuilder: {}", (Object)builder);
            answer = this.createTransactionErrorHandler(route, processor, builder);
        } else {
            if (builder != null) {
                LOG.debug("The ErrorHandlerBuilder configured is not a TransactionErrorHandlerBuilder: {}", (Object)builder);
            } else {
                LOG.debug("No ErrorHandlerBuilder configured, will use default TransactionErrorHandlerBuilder settings");
            }
            TransactionErrorHandlerBuilder txBuilder = new TransactionErrorHandlerBuilder();
            txBuilder.setTransactionTemplate(this.getTransactionTemplate());
            txBuilder.setSpringTransactionPolicy(this);
            if (builder != null) {
                route.addErrorHandlerFactoryReference((ErrorHandlerFactory)builder, (ErrorHandlerFactory)txBuilder);
            }
            answer = this.createTransactionErrorHandler(route, processor, (ErrorHandlerBuilder)txBuilder);
            route.setErrorHandlerFactory((ErrorHandlerFactory)txBuilder);
        }
        return answer;
    }

    protected TransactionErrorHandler createTransactionErrorHandler(Route route, Processor processor, ErrorHandlerBuilder builder) {
        TransactionErrorHandler answer;
        try {
            answer = (TransactionErrorHandler)ErrorHandlerReifier.reifier((Route)route, (ErrorHandlerFactory)builder).createErrorHandler(processor);
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
        return answer;
    }

    public TransactionTemplate getTransactionTemplate() {
        if (this.template == null) {
            ObjectHelper.notNull((Object)this.transactionManager, (String)"transactionManager");
            this.template = new TransactionTemplate(this.transactionManager);
            if (this.propagationBehaviorName != null) {
                this.template.setPropagationBehaviorName(this.propagationBehaviorName);
            }
        }
        return this.template;
    }

    public void setTransactionTemplate(TransactionTemplate template) {
        this.template = template;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setPropagationBehaviorName(String propagationBehaviorName) {
        this.propagationBehaviorName = propagationBehaviorName;
    }

    public String getPropagationBehaviorName() {
        return this.propagationBehaviorName;
    }
}

