/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.auth;

import com.google.common.base.Objects;
import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.cassandra.auth.IResource;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.commons.lang3.StringUtils;

public class RoleResource
implements IResource,
Comparable<RoleResource> {
    private static final Set<Permission> ROOT_LEVEL_PERMISSIONS = Sets.immutableEnumSet((Enum)Permission.CREATE, (Enum[])new Permission[]{Permission.ALTER, Permission.DROP, Permission.AUTHORIZE, Permission.DESCRIBE});
    private static final Set<Permission> ROLE_LEVEL_PERMISSIONS = Sets.immutableEnumSet((Enum)Permission.ALTER, (Enum[])new Permission[]{Permission.DROP, Permission.AUTHORIZE});
    private static final String ROOT_NAME = "roles";
    private static final RoleResource ROOT_RESOURCE = new RoleResource();
    private final Level level;
    private final String name;

    private RoleResource() {
        this.level = Level.ROOT;
        this.name = null;
    }

    private RoleResource(String name) {
        this.level = Level.ROLE;
        this.name = name;
    }

    public static RoleResource root() {
        return ROOT_RESOURCE;
    }

    public static RoleResource role(String name) {
        return new RoleResource(name);
    }

    public static RoleResource fromName(String name) {
        String[] parts = StringUtils.split((String)name, (char)'/');
        if (!parts[0].equals(ROOT_NAME) || parts.length > 2) {
            throw new IllegalArgumentException(String.format("%s is not a valid role resource name", name));
        }
        if (parts.length == 1) {
            return RoleResource.root();
        }
        return RoleResource.role(parts[1]);
    }

    @Override
    public String getName() {
        return this.level == Level.ROOT ? ROOT_NAME : String.format("%s/%s", ROOT_NAME, this.name);
    }

    public String getRoleName() {
        if (this.level == Level.ROOT) {
            throw new IllegalStateException(String.format("%s role resource has no role name", new Object[]{this.level}));
        }
        return this.name;
    }

    @Override
    public IResource getParent() {
        if (this.level == Level.ROLE) {
            return RoleResource.root();
        }
        throw new IllegalStateException("Root-level resource can't have a parent");
    }

    @Override
    public boolean hasParent() {
        return this.level != Level.ROOT;
    }

    @Override
    public boolean exists() {
        return this.level == Level.ROOT || DatabaseDescriptor.getRoleManager().isExistingRole(this);
    }

    @Override
    public Set<Permission> applicablePermissions() {
        return this.level == Level.ROOT ? ROOT_LEVEL_PERMISSIONS : ROLE_LEVEL_PERMISSIONS;
    }

    @Override
    public int compareTo(RoleResource o) {
        return this.name.compareTo(o.name);
    }

    public String toString() {
        return this.level == Level.ROOT ? "<all roles>" : String.format("<role %s>", this.name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RoleResource)) {
            return false;
        }
        RoleResource rs = (RoleResource)o;
        return Objects.equal((Object)((Object)this.level), (Object)((Object)rs.level)) && Objects.equal((Object)this.name, (Object)rs.name);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.level, this.name});
    }

    static enum Level {
        ROOT,
        ROLE;

    }
}

