/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.concurrent;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import org.apache.cassandra.concurrent.SEPExecutor;
import org.apache.cassandra.concurrent.SharedExecutorPool;
import org.apache.cassandra.utils.JVMStabilityInspector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SEPWorker
extends AtomicReference<Work>
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(SEPWorker.class);
    final Long workerId;
    final Thread thread;
    final SharedExecutorPool pool;
    long prevStopCheck = 0L;
    long soleSpinnerSpinTime = 0L;
    private static final long stopCheckInterval = TimeUnit.MILLISECONDS.toNanos(10L);

    SEPWorker(Long workerId, Work initialState, SharedExecutorPool pool) {
        this.pool = pool;
        this.workerId = workerId;
        this.thread = new Thread((Runnable)this, pool.poolName + "-Worker-" + workerId);
        this.thread.setDaemon(true);
        this.set(initialState);
        this.thread.start();
    }

    @Override
    public void run() {
        SEPExecutor assigned = null;
        Runnable task = null;
        try {
            while (true) {
                boolean shutdown;
                if (this.isSpinning() && !this.selfAssign()) {
                    this.doWaitSpin();
                    continue;
                }
                if (this.stop()) {
                    while (this.isStopped()) {
                        LockSupport.park();
                    }
                }
                if ((assigned = ((Work)this.get()).assigned) == null) continue;
                task = assigned.tasks.poll();
                this.set(Work.WORKING);
                while (true) {
                    assigned.maybeSchedule();
                    task.run();
                    task = null;
                    shutdown = assigned.shuttingDown;
                    if (shutdown || !assigned.takeTaskPermit()) break;
                    task = assigned.tasks.poll();
                }
                assigned.returnWorkPermit();
                if (shutdown && assigned.getActiveCount() == 0) {
                    assigned.shutdown.signalAll();
                }
                assigned = null;
                if (this.selfAssign()) continue;
                this.startSpinning();
            }
        }
        catch (Throwable t) {
            JVMStabilityInspector.inspectThrowable(t);
            do {
                if (((Work)this.get()).assigned == null) continue;
                assigned = ((Work)this.get()).assigned;
                this.set(Work.WORKING);
            } while (!this.assign(Work.STOPPED, true));
            if (assigned != null) {
                assigned.returnWorkPermit();
            }
            if (task != null) {
                logger.error("Failed to execute task, unexpected exception killed worker: {}", t);
            } else {
                logger.error("Unexpected exception killed worker: {}", t);
            }
            return;
        }
    }

    boolean assign(Work work, boolean self) {
        Work state = (Work)this.get();
        while (state.canAssign(self)) {
            if (!this.compareAndSet(state, work)) {
                state = (Work)this.get();
                continue;
            }
            if (state.isSpinning()) {
                this.stopSpinning();
            }
            if (work.isStop()) {
                this.pool.descheduled.put(this.workerId, this);
            }
            if (!(!state.isStopped() || work.isStop() && this.stop())) {
                LockSupport.unpark(this.thread);
            }
            return true;
        }
        return false;
    }

    private boolean selfAssign() {
        if (!((Work)this.get()).canAssign(true)) {
            return false;
        }
        for (SEPExecutor exec : this.pool.executors) {
            if (!exec.takeWorkPermit(true)) continue;
            Work work = new Work(exec);
            if (this.assign(work, true)) {
                return true;
            }
            this.pool.schedule(work);
            assert (((Work)this.get()).assigned != null);
            return true;
        }
        return false;
    }

    private void startSpinning() {
        assert (this.get() == Work.WORKING);
        this.pool.spinningCount.incrementAndGet();
        this.set(Work.SPINNING);
    }

    private void stopSpinning() {
        if (this.pool.spinningCount.decrementAndGet() == 0) {
            for (SEPExecutor executor : this.pool.executors) {
                executor.maybeSchedule();
            }
        }
        this.soleSpinnerSpinTime = 0L;
        this.prevStopCheck = 0L;
    }

    private void doWaitSpin() {
        long sleep = 10000L * (long)this.pool.spinningCount.get();
        sleep = Math.min(1000000L, sleep);
        sleep = (long)((double)sleep * Math.random());
        sleep = Math.max(10000L, sleep);
        long start = System.nanoTime();
        Long target = start + sleep;
        if (this.pool.spinning.putIfAbsent(target, this) != null) {
            return;
        }
        LockSupport.parkNanos(sleep);
        this.pool.spinning.remove(target, this);
        long end = System.nanoTime();
        long spin = end - start;
        long stopCheck = this.pool.stopCheck.addAndGet(spin);
        this.maybeStop(stopCheck, end);
        this.soleSpinnerSpinTime = this.prevStopCheck + spin == stopCheck ? (this.soleSpinnerSpinTime += spin) : 0L;
        this.prevStopCheck = stopCheck;
    }

    private void maybeStop(long stopCheck, long now) {
        long delta = now - stopCheck;
        if (delta <= 0L) {
            if (this.pool.stopCheck.compareAndSet(stopCheck, now - stopCheckInterval) && !this.assign(Work.STOP_SIGNALLED, true)) {
                this.pool.schedule(Work.STOP_SIGNALLED);
            }
        } else if (this.soleSpinnerSpinTime > stopCheckInterval && this.pool.spinningCount.get() == 1) {
            this.assign(Work.STOP_SIGNALLED, true);
        } else {
            while (delta > stopCheckInterval * 2L && !this.pool.stopCheck.compareAndSet(stopCheck, now - stopCheckInterval)) {
                stopCheck = this.pool.stopCheck.get();
                delta = now - stopCheck;
            }
        }
    }

    private boolean isSpinning() {
        return ((Work)this.get()).isSpinning();
    }

    private boolean stop() {
        return ((Work)this.get()).isStop() && this.compareAndSet(Work.STOP_SIGNALLED, Work.STOPPED);
    }

    private boolean isStopped() {
        return ((Work)this.get()).isStopped();
    }

    static final class Work {
        static final Work STOP_SIGNALLED = new Work();
        static final Work STOPPED = new Work();
        static final Work SPINNING = new Work();
        static final Work WORKING = new Work();
        final SEPExecutor assigned;

        Work(SEPExecutor executor) {
            this.assigned = executor;
        }

        private Work() {
            this.assigned = null;
        }

        boolean canAssign(boolean self) {
            return this.assigned == null && (self || !this.isWorking());
        }

        boolean isSpinning() {
            return this == SPINNING;
        }

        boolean isWorking() {
            return this == WORKING;
        }

        boolean isStop() {
            return this == STOP_SIGNALLED;
        }

        boolean isStopped() {
            return this == STOPPED;
        }

        boolean isAssigned() {
            return this.assigned != null;
        }
    }
}

