/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import org.apache.cassandra.auth.AuthenticatedUser;
import org.apache.cassandra.auth.IRoleManager;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.auth.RoleOptions;
import org.apache.cassandra.auth.RoleResource;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.cql3.RoleName;
import org.apache.cassandra.cql3.statements.AuthenticationStatement;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.transport.messages.ResultMessage;

public class AlterRoleStatement
extends AuthenticationStatement {
    private final RoleResource role;
    private final RoleOptions opts;

    public AlterRoleStatement(RoleName name, RoleOptions opts) {
        this.role = RoleResource.role(name.getName());
        this.opts = opts;
    }

    @Override
    public void validate(ClientState state) throws RequestValidationException {
        this.opts.validate();
        if (this.opts.isEmpty()) {
            throw new InvalidRequestException("ALTER [ROLE|USER] can't be empty");
        }
        state.ensureNotAnonymous();
        if (!DatabaseDescriptor.getRoleManager().isExistingRole(this.role)) {
            throw new InvalidRequestException(String.format("%s doesn't exist", this.role.getRoleName()));
        }
    }

    @Override
    public void checkAccess(ClientState state) throws UnauthorizedException {
        AuthenticatedUser user = state.getUser();
        boolean isSuper = user.isSuper();
        if (this.opts.getSuperuser().isPresent() && user.getRoles().contains(this.role)) {
            throw new UnauthorizedException("You aren't allowed to alter your own superuser status or that of a role granted to you");
        }
        if (this.opts.getSuperuser().isPresent() && !isSuper) {
            throw new UnauthorizedException("Only superusers are allowed to alter superuser status");
        }
        if (isSuper) {
            return;
        }
        if (user.getName().equals(this.role.getRoleName())) {
            for (IRoleManager.Option option : this.opts.getOptions().keySet()) {
                if (DatabaseDescriptor.getRoleManager().alterableOptions().contains((Object)option)) continue;
                throw new UnauthorizedException(String.format("You aren't allowed to alter %s", new Object[]{option}));
            }
        } else {
            super.checkPermission(state, Permission.ALTER, this.role);
        }
    }

    @Override
    public ResultMessage execute(ClientState state) throws RequestValidationException, RequestExecutionException {
        if (!this.opts.isEmpty()) {
            DatabaseDescriptor.getRoleManager().alterRole(state.getUser(), this.role, this.opts);
        }
        return null;
    }
}

