/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.util.List;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.IndexExpression;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowPosition;
import org.apache.cassandra.db.filter.IDiskAtomFilter;
import org.apache.cassandra.db.filter.SliceQueryFilter;
import org.apache.cassandra.db.index.SecondaryIndexManager;
import org.apache.cassandra.db.index.SecondaryIndexSearcher;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.net.MessageOut;
import org.apache.cassandra.service.IReadCommand;

public abstract class AbstractRangeCommand
implements IReadCommand {
    public final String keyspace;
    public final String columnFamily;
    public final long timestamp;
    public final AbstractBounds<RowPosition> keyRange;
    public final IDiskAtomFilter predicate;
    public final List<IndexExpression> rowFilter;
    public final SecondaryIndexSearcher searcher;

    public AbstractRangeCommand(String keyspace, String columnFamily, long timestamp, AbstractBounds<RowPosition> keyRange, IDiskAtomFilter predicate, List<IndexExpression> rowFilter) {
        this.keyspace = keyspace;
        this.columnFamily = columnFamily;
        this.timestamp = timestamp;
        this.keyRange = keyRange;
        this.predicate = predicate;
        this.rowFilter = rowFilter;
        SecondaryIndexManager indexManager = Keyspace.open((String)keyspace).getColumnFamilyStore((String)columnFamily).indexManager;
        this.searcher = indexManager.getHighestSelectivityIndexSearcher(rowFilter);
    }

    public boolean requiresScanningAllRanges() {
        return this.searcher != null && this.searcher.requiresScanningAllRanges(this.rowFilter);
    }

    public List<Row> postReconciliationProcessing(List<Row> rows) {
        return this.searcher == null ? this.trim(rows) : this.trim(this.searcher.postReconciliationProcessing(this.rowFilter, rows));
    }

    private List<Row> trim(List<Row> rows) {
        if (this.countCQL3Rows() || this.ignoredTombstonedPartitions()) {
            return rows;
        }
        return rows.size() > this.limit() ? rows.subList(0, this.limit()) : rows;
    }

    @Override
    public String getKeyspace() {
        return this.keyspace;
    }

    public abstract MessageOut<? extends AbstractRangeCommand> createMessage();

    public abstract AbstractRangeCommand forSubRange(AbstractBounds<RowPosition> var1);

    public abstract AbstractRangeCommand withUpdatedLimit(int var1);

    public abstract int limit();

    public abstract boolean countCQL3Rows();

    public boolean ignoredTombstonedPartitions() {
        if (!(this.predicate instanceof SliceQueryFilter)) {
            return false;
        }
        return ((SliceQueryFilter)this.predicate).compositesToGroup == -2;
    }

    public abstract List<Row> executeLocally();

    @Override
    public long getTimeout() {
        return DatabaseDescriptor.getRangeRpcTimeout();
    }
}

