/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.index;

import java.io.IOException;
import java.util.Set;
import java.util.UUID;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.compaction.CompactionInfo;
import org.apache.cassandra.db.compaction.CompactionInterruptedException;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.io.sstable.ReducingKeyIterator;
import org.apache.cassandra.utils.UUIDGen;

public class SecondaryIndexBuilder
extends CompactionInfo.Holder {
    private final ColumnFamilyStore cfs;
    private final Set<String> idxNames;
    private final ReducingKeyIterator iter;
    private final UUID compactionId;

    public SecondaryIndexBuilder(ColumnFamilyStore cfs, Set<String> idxNames, ReducingKeyIterator iter) {
        this.cfs = cfs;
        this.idxNames = idxNames;
        this.iter = iter;
        this.compactionId = UUIDGen.getTimeUUID();
    }

    @Override
    public CompactionInfo getCompactionInfo() {
        return new CompactionInfo(this.cfs.metadata, OperationType.INDEX_BUILD, this.iter.getBytesRead(), this.iter.getTotalBytes(), this.compactionId);
    }

    public void build() {
        while (this.iter.hasNext()) {
            if (this.isStopRequested()) {
                throw new CompactionInterruptedException(this.getCompactionInfo());
            }
            DecoratedKey key = this.iter.next();
            Keyspace.indexRow(key, this.cfs, this.idxNames);
        }
        try {
            this.iter.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

