/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import com.google.common.collect.Iterables;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.ReadResponse;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.columniterator.IdentityQueryFilter;
import org.apache.cassandra.db.filter.IDiskAtomFilter;
import org.apache.cassandra.db.filter.QueryFilter;
import org.apache.cassandra.net.AsyncOneResponse;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.AbstractRowResolver;
import org.apache.cassandra.service.DigestMismatchException;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.CloseableIterator;
import org.apache.cassandra.utils.FBUtilities;

public class RowDataResolver
extends AbstractRowResolver {
    private int maxLiveCount = 0;
    public List<AsyncOneResponse> repairResults = Collections.emptyList();
    private final IDiskAtomFilter filter;
    private final long timestamp;

    public RowDataResolver(String keyspaceName, ByteBuffer key, IDiskAtomFilter qFilter, long timestamp, int maxResponseCount) {
        super(key, keyspaceName, maxResponseCount);
        this.filter = qFilter;
        this.timestamp = timestamp;
    }

    @Override
    public Row resolve() throws DigestMismatchException {
        ColumnFamily resolved;
        int replyCount = this.replies.size();
        if (logger.isTraceEnabled()) {
            logger.trace("resolving {} responses", (Object)replyCount);
        }
        long start = System.nanoTime();
        if (replyCount > 1) {
            ArrayList<ColumnFamily> versions = new ArrayList<ColumnFamily>(replyCount);
            ArrayList<InetAddress> endpoints = new ArrayList<InetAddress>(replyCount);
            for (MessageIn message : this.replies) {
                ReadResponse response = (ReadResponse)message.payload;
                ColumnFamily cf = response.row().cf;
                assert (!response.isDigestQuery()) : "Received digest response to repair read from " + message.from;
                versions.add(cf);
                endpoints.add(message.from);
                int liveCount = cf == null ? 0 : this.filter.getLiveCount(cf, this.timestamp);
                if (liveCount <= this.maxLiveCount) continue;
                this.maxLiveCount = liveCount;
            }
            resolved = RowDataResolver.resolveSuperset(versions, this.timestamp);
            if (logger.isTraceEnabled()) {
                logger.trace("versions merged");
            }
            if (resolved != null) {
                this.repairResults = RowDataResolver.scheduleRepairs(resolved, this.keyspaceName, this.key, versions, endpoints);
            }
        } else {
            resolved = ((ReadResponse)((MessageIn)this.replies.get((int)0)).payload).row().cf;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("resolve: {} ms.", (Object)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start));
        }
        return new Row(this.key, resolved);
    }

    public static List<AsyncOneResponse> scheduleRepairs(ColumnFamily resolved, String keyspaceName, DecoratedKey key, List<ColumnFamily> versions, List<InetAddress> endpoints) {
        ArrayList<AsyncOneResponse> results = new ArrayList<AsyncOneResponse>(versions.size());
        for (int i = 0; i < versions.size(); ++i) {
            ColumnFamily diffCf = ColumnFamily.diff(versions.get(i), resolved);
            if (diffCf == null) continue;
            Mutation mutation = new Mutation(keyspaceName, key.getKey(), diffCf);
            Tracing.trace("Sending read-repair-mutation to {}", (Object)endpoints.get(i));
            results.add(MessagingService.instance().sendRR(mutation.createMessage(MessagingService.Verb.READ_REPAIR), endpoints.get(i)));
        }
        return results;
    }

    static ColumnFamily resolveSuperset(Iterable<ColumnFamily> versions, long now) {
        assert (Iterables.size(versions) > 0);
        ColumnFamily resolved = null;
        for (ColumnFamily cf : versions) {
            if (cf == null) continue;
            if (resolved == null) {
                resolved = cf.cloneMeShallow();
                continue;
            }
            resolved.delete(cf);
        }
        if (resolved == null) {
            return null;
        }
        QueryFilter filter = new QueryFilter(null, resolved.metadata().cfName, new IdentityQueryFilter(), now);
        ArrayList<CloseableIterator<Cell>> iters = new ArrayList<CloseableIterator<Cell>>(Iterables.size(versions));
        for (ColumnFamily version : versions) {
            if (version == null) continue;
            iters.add(FBUtilities.closeableIterator(version.iterator()));
        }
        filter.collateColumns(resolved, iters, Integer.MIN_VALUE);
        return ColumnFamilyStore.removeDeleted(resolved, Integer.MIN_VALUE);
    }

    @Override
    public Row getData() {
        assert (!this.replies.isEmpty());
        return ((ReadResponse)((MessageIn)this.replies.get((int)0)).payload).row();
    }

    @Override
    public boolean isDataPresent() {
        return !this.replies.isEmpty();
    }

    public int getMaxLiveCount() {
        return this.maxLiveCount;
    }
}

