/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.paxos;

import com.google.common.util.concurrent.Striped;
import java.nio.ByteBuffer;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.service.paxos.Commit;
import org.apache.cassandra.service.paxos.PrepareResponse;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.UUIDGen;

public class PaxosState {
    private static final Striped<Lock> LOCKS = Striped.lazyWeakLock((int)(DatabaseDescriptor.getConcurrentWriters() * 1024));
    private final Commit promised;
    private final Commit accepted;
    private final Commit mostRecentCommit;

    public PaxosState(ByteBuffer key, CFMetaData metadata) {
        this(Commit.emptyCommit(key, metadata), Commit.emptyCommit(key, metadata), Commit.emptyCommit(key, metadata));
    }

    public PaxosState(Commit promised, Commit accepted, Commit mostRecentCommit) {
        assert (promised.key == accepted.key && accepted.key == mostRecentCommit.key);
        assert (promised.update.metadata() == accepted.update.metadata() && accepted.update.metadata() == mostRecentCommit.update.metadata());
        this.promised = promised;
        this.accepted = accepted;
        this.mostRecentCommit = mostRecentCommit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PrepareResponse prepare(Commit toPrepare) {
        long start = System.nanoTime();
        try {
            PaxosState state;
            Lock lock;
            block8: {
                lock = (Lock)LOCKS.get((Object)toPrepare.key);
                lock.lock();
                try {
                    long now = UUIDGen.unixTimestamp(toPrepare.ballot);
                    state = SystemKeyspace.loadPaxosState(toPrepare.key, toPrepare.update.metadata(), now);
                    if (!toPrepare.isAfter(state.promised)) break block8;
                    Tracing.trace("Promising ballot {}", (Object)toPrepare.ballot);
                    SystemKeyspace.savePaxosPromise(toPrepare);
                    PrepareResponse prepareResponse = new PrepareResponse(true, state.accepted, state.mostRecentCommit);
                    lock.unlock();
                    return prepareResponse;
                }
                catch (Throwable throwable) {
                    lock.unlock();
                    throw throwable;
                }
            }
            Tracing.trace("Promise rejected; {} is not sufficiently newer than {}", (Object)toPrepare, (Object)state.promised);
            PrepareResponse prepareResponse = new PrepareResponse(false, state.promised, state.mostRecentCommit);
            lock.unlock();
            return prepareResponse;
        }
        finally {
            Keyspace.open((String)toPrepare.update.metadata().ksName).getColumnFamilyStore((UUID)toPrepare.update.metadata().cfId).metric.casPrepare.addNano(System.nanoTime() - start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean propose(Commit proposal) {
        long start = System.nanoTime();
        try {
            PaxosState state;
            Lock lock;
            block8: {
                lock = (Lock)LOCKS.get((Object)proposal.key);
                lock.lock();
                try {
                    long now = UUIDGen.unixTimestamp(proposal.ballot);
                    state = SystemKeyspace.loadPaxosState(proposal.key, proposal.update.metadata(), now);
                    if (!proposal.hasBallot(state.promised.ballot) && !proposal.isAfter(state.promised)) break block8;
                    Tracing.trace("Accepting proposal {}", (Object)proposal);
                    SystemKeyspace.savePaxosProposal(proposal);
                    Boolean bl = true;
                    lock.unlock();
                    return bl;
                }
                catch (Throwable throwable) {
                    lock.unlock();
                    throw throwable;
                }
            }
            Tracing.trace("Rejecting proposal for {} because inProgress is now {}", (Object)proposal, (Object)state.promised);
            Boolean bl = false;
            lock.unlock();
            return bl;
        }
        finally {
            Keyspace.open((String)proposal.update.metadata().ksName).getColumnFamilyStore((UUID)proposal.update.metadata().cfId).metric.casPropose.addNano(System.nanoTime() - start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void commit(Commit proposal) {
        long start = System.nanoTime();
        try {
            if (UUIDGen.unixTimestamp(proposal.ballot) >= SystemKeyspace.getTruncatedAt(proposal.update.metadata().cfId)) {
                Tracing.trace("Committing proposal {}", (Object)proposal);
                Mutation mutation = proposal.makeMutation();
                Keyspace.open(mutation.getKeyspaceName()).apply(mutation, true);
            } else {
                Tracing.trace("Not committing proposal {} as ballot timestamp predates last truncation time", (Object)proposal);
            }
            SystemKeyspace.savePaxosCommit(proposal);
        }
        finally {
            Keyspace.open((String)proposal.update.metadata().ksName).getColumnFamilyStore((UUID)proposal.update.metadata().cfId).metric.casCommit.addNano(System.nanoTime() - start);
        }
    }
}

