/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.functors;

import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import org.apache.commons.collections4.Closure;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.Transformer;

final class FunctorUtils {
    static <T> Closure<T> coerce(Closure<? super T> closure) {
        return closure;
    }

    static <T> Predicate<T> coerce(Predicate<? super T> predicate) {
        return predicate;
    }

    static <I, O> Transformer<I, O> coerce(Transformer<? super I, ? extends O> transformer) {
        return transformer;
    }

    static <E> Closure<E>[] copy(Closure<? super E> ... closures) {
        if (closures == null) {
            return null;
        }
        return (Closure[])closures.clone();
    }

    static <T> Predicate<T>[] copy(Predicate<? super T> ... predicates) {
        if (predicates == null) {
            return null;
        }
        return (Predicate[])predicates.clone();
    }

    static <I, O> Transformer<I, O>[] copy(Transformer<? super I, ? extends O> ... transformers) {
        if (transformers == null) {
            return null;
        }
        return (Transformer[])transformers.clone();
    }

    static void validate(Closure<?> ... closures) {
        Objects.requireNonNull(closures, "closures");
        for (int i = 0; i < closures.length; ++i) {
            if (closures[i] != null) continue;
            throw new NullPointerException("closures[" + i + "]");
        }
    }

    static <T> Predicate<? super T>[] validate(Collection<? extends Predicate<? super T>> predicates) {
        Objects.requireNonNull(predicates, "predicates");
        Predicate[] preds = new Predicate[predicates.size()];
        int i = 0;
        Iterator<Predicate<T>> iterator = predicates.iterator();
        while (iterator.hasNext()) {
            Predicate<? super T> predicate;
            preds[i] = predicate = iterator.next();
            if (preds[i] == null) {
                throw new NullPointerException("predicates[" + i + "]");
            }
            ++i;
        }
        return preds;
    }

    static void validate(Predicate<?> ... predicates) {
        Objects.requireNonNull(predicates, "predicates");
        for (int i = 0; i < predicates.length; ++i) {
            if (predicates[i] != null) continue;
            throw new NullPointerException("predicates[" + i + "]");
        }
    }

    static void validate(Transformer<?, ?> ... transformers) {
        Objects.requireNonNull(transformers, "transformers");
        for (int i = 0; i < transformers.length; ++i) {
            if (transformers[i] != null) continue;
            throw new NullPointerException("transformers[" + i + "]");
        }
    }

    private FunctorUtils() {
    }
}

