/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.handler.logical;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.ws.Binding;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.XMLUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.jaxws.handler.AbstractJAXWSHandlerInterceptor;
import org.apache.cxf.jaxws.handler.HandlerChainInvoker;
import org.apache.cxf.jaxws.handler.logical.LogicalHandlerInInterceptor;
import org.apache.cxf.jaxws.handler.logical.LogicalMessageContextImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.staxutils.W3CDOMStreamReader;
import org.apache.cxf.staxutils.W3CDOMStreamWriter;
import org.apache.cxf.transport.MessageObserver;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class LogicalHandlerOutInterceptor
extends AbstractJAXWSHandlerInterceptor<Message> {
    public static final String ORIGINAL_WRITER = LogicalHandlerOutInterceptor.class.getName() + ".original_writer";
    private LogicalHandlerOutEndingInterceptor ending;

    public LogicalHandlerOutInterceptor(Binding binding) {
        super(binding, "pre-marshal");
        this.ending = new LogicalHandlerOutEndingInterceptor(binding);
    }

    public void handleMessage(Message message) throws Fault {
        if (this.binding.getHandlerChain().isEmpty()) {
            return;
        }
        HandlerChainInvoker invoker = this.getInvoker(message);
        if (invoker.getLogicalHandlers().isEmpty()) {
            return;
        }
        try {
            XMLStreamWriter origWriter = (XMLStreamWriter)message.getContent(XMLStreamWriter.class);
            Object nd = (Node)message.getContent(Node.class);
            SOAPMessage m = (SOAPMessage)message.getContent(SOAPMessage.class);
            Object document = null;
            if (m != null) {
                document = m.getSOAPPart();
            } else if (nd != null) {
                document = nd.getOwnerDocument();
            } else {
                document = XMLUtils.newDocument();
                message.setContent(Node.class, document);
                nd = document;
            }
            W3CDOMStreamWriter writer = new W3CDOMStreamWriter(document.createDocumentFragment());
            message.setContent(XMLStreamWriter.class, (Object)writer);
            message.put((Object)ORIGINAL_WRITER, (Object)origWriter);
            message.getInterceptorChain().add((Interceptor)this.ending);
        }
        catch (ParserConfigurationException e) {
            throw new Fault((Throwable)e);
        }
    }

    public void handleFault(Message message) {
        super.handleFault(message);
        XMLStreamWriter os = (XMLStreamWriter)message.get((Object)ORIGINAL_WRITER);
        if (os != null) {
            message.setContent(XMLStreamWriter.class, (Object)os);
        }
    }

    private class LogicalHandlerOutEndingInterceptor
    extends AbstractJAXWSHandlerInterceptor<Message> {
        public LogicalHandlerOutEndingInterceptor(Binding binding) {
            super(binding, "post-marshal");
        }

        public void handleMessage(Message message) throws Fault {
            W3CDOMStreamWriter domWriter = (W3CDOMStreamWriter)message.getContent(XMLStreamWriter.class);
            XMLStreamWriter origWriter = (XMLStreamWriter)message.get((Object)ORIGINAL_WRITER);
            HandlerChainInvoker invoker = this.getInvoker(message);
            LogicalMessageContextImpl lctx = new LogicalMessageContextImpl(message);
            invoker.setLogicalMessageContext(lctx);
            boolean requestor = this.isRequestor(message);
            XMLStreamReader reader = (XMLStreamReader)message.get((Object)"LogicalHandlerInterceptor.INREADER");
            SOAPMessage origMessage = null;
            if (reader != null) {
                origMessage = (SOAPMessage)message.getContent(SOAPMessage.class);
                message.setContent(XMLStreamReader.class, (Object)reader);
                message.removeContent(SOAPMessage.class);
            } else if (domWriter.getCurrentFragment() != null) {
                Node nd;
                DocumentFragment frag = domWriter.getCurrentFragment();
                for (nd = frag.getFirstChild(); nd != null && !(nd instanceof Element); nd = nd.getNextSibling()) {
                }
                DOMSource source = new DOMSource(nd);
                message.setContent(Source.class, (Object)source);
                message.setContent(XMLStreamReader.class, (Object)new W3CDOMStreamReader(domWriter.getCurrentFragment()));
            } else if (domWriter.getDocument().getDocumentElement() != null) {
                DOMSource source = new DOMSource(domWriter.getDocument());
                message.setContent(Source.class, (Object)source);
                message.setContent(XMLStreamReader.class, (Object)StaxUtils.createXMLStreamReader((Document)domWriter.getDocument()));
            }
            if (!invoker.invokeLogicalHandlers(requestor, lctx)) {
                if (requestor) {
                    message.getInterceptorChain().abort();
                    if (!message.getExchange().isOneWay()) {
                        Endpoint e = (Endpoint)message.getExchange().get(Endpoint.class);
                        MessageImpl responseMsg = new MessageImpl();
                        responseMsg.setExchange(message.getExchange());
                        responseMsg = e.getBinding().createMessage((Message)responseMsg);
                        MessageObserver observer = (MessageObserver)message.getExchange().get(MessageObserver.class);
                        if (observer != null) {
                            responseMsg.setContent(XMLStreamReader.class, message.getContent(XMLStreamReader.class));
                            message.getExchange().setInMessage((Message)responseMsg);
                            responseMsg.put((Object)"starting_at_interceptor_id", (Object)LogicalHandlerInInterceptor.class.getName());
                            observer.onMessage((Message)responseMsg);
                        }
                    }
                }
                return;
            }
            if (origMessage != null) {
                message.setContent(SOAPMessage.class, (Object)origMessage);
            }
            try {
                reader = (XMLStreamReader)message.getContent(XMLStreamReader.class);
                message.removeContent(XMLStreamReader.class);
                if (reader != null) {
                    StaxUtils.copy((XMLStreamReader)reader, (XMLStreamWriter)origWriter);
                } else if (domWriter.getDocument().getDocumentElement() != null) {
                    StaxUtils.copy((Document)domWriter.getDocument(), (XMLStreamWriter)origWriter);
                }
                message.setContent(XMLStreamWriter.class, (Object)origWriter);
            }
            catch (XMLStreamException e) {
                throw new Fault((Throwable)e);
            }
        }
    }
}

