/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.tools.common.Tag;

public final class ToolsStaxUtils {
    private ToolsStaxUtils() {
    }

    public static List<Tag> getTags(File source) throws Exception {
        ArrayList<Tag> tags = new ArrayList<Tag>();
        List<String> ignoreEmptyTags = Arrays.asList("sequence");
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(source));){
            XMLStreamReader reader = StaxUtils.createXMLStreamReader((InputStream)is);
            Tag newTag = null;
            int count = 0;
            QName checkingPoint = null;
            Stack<Tag> stack = new Stack<Tag>();
            while (reader.hasNext()) {
                int event = reader.next();
                if (checkingPoint != null) {
                    ++count;
                }
                if (event == 1) {
                    newTag = new Tag();
                    newTag.setName(reader.getName());
                    if (ignoreEmptyTags.contains(reader.getLocalName())) {
                        checkingPoint = reader.getName();
                    }
                    for (int i = 0; i < reader.getAttributeCount(); ++i) {
                        newTag.getAttributes().put(reader.getAttributeName(i), reader.getAttributeValue(i));
                    }
                    stack.push(newTag);
                }
                if (event == 4) {
                    newTag.setText(reader.getText());
                }
                if (event != 2) continue;
                Tag startTag = (Tag)stack.pop();
                if (checkingPoint != null && checkingPoint.equals(reader.getName())) {
                    if (count != 1) {
                        tags.add(startTag);
                    }
                    count = 0;
                    checkingPoint = null;
                    continue;
                }
                tags.add(startTag);
            }
            reader.close();
        }
        return tags;
    }

    public static Tag getTagTree(File source) throws Exception {
        return ToolsStaxUtils.getTagTree(source, new ArrayList<String>());
    }

    public static Tag getTagTree(File source, List<String> ignoreAttr) throws Exception {
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(source));){
            Tag tag = ToolsStaxUtils.getTagTree(is, ignoreAttr, null);
            return tag;
        }
    }

    public static Tag getTagTree(File source, List<String> ignoreAttr, Map<QName, Set<String>> types) throws Exception {
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(source));){
            Tag tag = ToolsStaxUtils.getTagTree(is, ignoreAttr, types);
            return tag;
        }
    }

    public static Tag getTagTree(InputStream is, List<String> ignoreAttr, Map<QName, Set<String>> types) throws Exception {
        Tag root = new Tag();
        root.setName(new QName("root", "root"));
        XMLStreamReader reader = StaxUtils.createXMLStreamReader((InputStream)is);
        Tag newTag = null;
        Tag currentTag = root;
        while (reader.hasNext()) {
            int event = reader.next();
            if (event == 1) {
                newTag = new Tag();
                newTag.setName(reader.getName());
                if (!ignoreAttr.isEmpty()) {
                    newTag.getIgnoreAttr().addAll(ignoreAttr);
                }
                for (int i = 0; i < reader.getAttributeCount(); ++i) {
                    String tp = reader.getAttributeValue(i);
                    if (ToolsStaxUtils.isType(types, reader.getName(), reader.getAttributeName(i))) {
                        int idx = tp.indexOf(58);
                        if (idx > 0 && tp.length() > idx && tp.substring(idx + 1).indexOf(58) == -1) {
                            String pfx = tp.substring(0, idx);
                            String ns = reader.getNamespaceURI(pfx);
                            if (ns != null) {
                                tp = "{" + ns + "}" + tp.substring(idx + 1);
                            }
                        } else {
                            String ns = reader.getNamespaceURI("");
                            if (ns != null) {
                                tp = "{" + ns + "}" + tp.substring(idx + 1);
                            }
                        }
                    }
                    newTag.getAttributes().put(reader.getAttributeName(i), tp);
                }
                newTag.setParent(currentTag);
                currentTag.getTags().add(newTag);
                currentTag = newTag;
            }
            if (event == 4) {
                newTag.setText(reader.getText());
            }
            if (event != 2) continue;
            currentTag = currentTag.getParent();
        }
        reader.close();
        return root;
    }

    private static boolean isType(Map<QName, Set<String>> types, QName name, QName attributeName) {
        if (types == null) {
            return false;
        }
        Set<String> a = types.get(name);
        return a != null && a.contains(attributeName.getLocalPart());
    }
}

