/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.NoSuchFileException;
import org.apache.commons.io.IOUtils;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    public static final Logger logger = LoggerFactory.getLogger(FileUtils.class);
    public static final String DATA_BASEDIR = PropertyUtils.getString("data.basedir.path", "/tmp/dolphinscheduler");

    private FileUtils() {
        throw new UnsupportedOperationException("Construct FileUtils");
    }

    public static String getDownloadFilename(String filename) {
        String fileName = String.format("%s/download/%s/%s", DATA_BASEDIR, DateUtils.getCurrentTime("yyyyMMddHHmmss"), filename);
        File file = new File(fileName);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        return fileName;
    }

    public static String getUploadFilename(String tenantCode, String filename) {
        String fileName = String.format("%s/%s/resources/%s", DATA_BASEDIR, tenantCode, filename);
        File file = new File(fileName);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        return fileName;
    }

    public static String getProcessExecDir(String tenant, long projectCode, long processDefineCode, int processDefineVersion, int processInstanceId, int taskInstanceId) {
        return String.format("%s/exec/process/%s/%d/%d_%d/%d/%d", DATA_BASEDIR, tenant, projectCode, processDefineCode, processDefineVersion, processInstanceId, taskInstanceId);
    }

    public static String getResourceViewSuffixes() {
        return PropertyUtils.getString("resource.view.suffixs", "txt,log,sh,bat,conf,cfg,py,java,sql,xml,hql,properties,json,yml,yaml,ini,js");
    }

    public static void createWorkDirIfAbsent(String execLocalPath) throws IOException {
        File execLocalPathFile;
        block3: {
            execLocalPathFile = new File(execLocalPath);
            if (execLocalPathFile.exists()) {
                try {
                    org.apache.commons.io.FileUtils.forceDelete((File)execLocalPathFile);
                }
                catch (Exception ex) {
                    if (ex instanceof NoSuchFileException || ex.getCause() instanceof NoSuchFileException) break block3;
                    throw ex;
                }
            }
        }
        org.apache.commons.io.FileUtils.forceMkdir((File)execLocalPathFile);
        String mkdirLog = "create dir success " + execLocalPath;
        logger.info(mkdirLog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeContent2File(String content, String filePath) {
        FileOutputStream fos = null;
        try {
            File distFile = new File(filePath);
            if (!distFile.getParentFile().exists() && !distFile.getParentFile().mkdirs()) {
                logger.error("mkdir parent failed");
                boolean bl = false;
                IOUtils.closeQuietly((OutputStream)fos);
                return bl;
            }
            fos = new FileOutputStream(filePath);
            IOUtils.write((String)content, (OutputStream)fos, (Charset)StandardCharsets.UTF_8);
            IOUtils.closeQuietly((OutputStream)fos);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            IOUtils.closeQuietly(fos);
        }
        return true;
    }

    public static void deleteFile(String filename) {
        org.apache.commons.io.FileUtils.deleteQuietly((File)new File(filename));
    }

    public static File[] getAllDir(String parentDir) {
        if (parentDir == null || "".equals(parentDir)) {
            throw new RuntimeException("parentDir can not be empty");
        }
        File file = new File(parentDir);
        if (!file.exists() || !file.isDirectory()) {
            throw new RuntimeException("parentDir not exist, or is not a directory:" + parentDir);
        }
        return file.listFiles(File::isDirectory);
    }

    public static String readFile2Str(InputStream inputStream) {
        try {
            int length;
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((length = inputStream.read(buffer)) != -1) {
                output.write(buffer, 0, length);
            }
            return output.toString("UTF-8");
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static boolean directoryTraversal(String filename) {
        if (filename.contains("/")) {
            return true;
        }
        File file = new File(filename);
        try {
            File canonical = file.getCanonicalFile();
            File absolute = file.getAbsoluteFile();
            return !canonical.equals(absolute);
        }
        catch (IOException e) {
            return true;
        }
    }
}

