/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.registry.mysql;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import lombok.NonNull;
import org.apache.dolphinscheduler.plugin.registry.mysql.MysqlRegistryConstant;
import org.apache.dolphinscheduler.plugin.registry.mysql.MysqlRegistryProperties;
import org.apache.dolphinscheduler.plugin.registry.mysql.model.DataType;
import org.apache.dolphinscheduler.plugin.registry.mysql.model.MysqlRegistryData;
import org.apache.dolphinscheduler.plugin.registry.mysql.model.MysqlRegistryLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MysqlOperator
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(MysqlOperator.class);
    private final HikariDataSource dataSource;
    private final long expireTimeWindow;

    public MysqlOperator(MysqlRegistryProperties registryProperties) {
        this.expireTimeWindow = (long)registryProperties.getTermExpireTimes() * registryProperties.getTermRefreshInterval().toMillis();
        HikariConfig hikariConfig = registryProperties.getHikariConfig();
        hikariConfig.setPoolName("MysqlRegistryDataSourcePool");
        this.dataSource = new HikariDataSource(hikariConfig);
    }

    public void healthCheck() throws SQLException {
        String sql = "select 1 from t_ds_mysql_registry_data";
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(sql);){
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet != null) {
                resultSet.close();
            }
        }
    }

    /*
     * Exception decompiling
     */
    public List<MysqlRegistryData> queryAllMysqlRegistryData() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Long insertOrUpdateEphemeralData(String key, String value) throws SQLException {
        Optional<MysqlRegistryData> mysqlRegistryDataOptional = this.selectByKey(key);
        if (mysqlRegistryDataOptional.isPresent()) {
            long id = mysqlRegistryDataOptional.get().getId();
            if (!this.updateValueById(id, value)) {
                throw new SQLException(String.format("update registry value failed, key: %s, value: %s", key, value));
            }
            return id;
        }
        MysqlRegistryData mysqlRegistryData = MysqlRegistryData.builder().key(key).data(value).type(DataType.EPHEMERAL.getTypeValue()).lastTerm(System.currentTimeMillis()).build();
        return this.insertMysqlRegistryData(mysqlRegistryData);
    }

    /*
     * Exception decompiling
     */
    private Optional<MysqlRegistryData> selectByKey(@NonNull String key) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean updateValueById(long id, String value) throws SQLException {
        String sql = "update t_ds_mysql_registry_data set data = ?, last_term = ? where id = ?";
        try (Connection connection = this.dataSource.getConnection();){
            boolean bl;
            block12: {
                PreparedStatement preparedStatement = connection.prepareStatement(sql);
                try {
                    preparedStatement.setString(1, value);
                    preparedStatement.setLong(2, System.currentTimeMillis());
                    preparedStatement.setLong(3, id);
                    boolean bl2 = bl = preparedStatement.executeUpdate() > 0;
                    if (preparedStatement == null) break block12;
                }
                catch (Throwable throwable) {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                preparedStatement.close();
            }
            return bl;
        }
    }

    private long insertMysqlRegistryData(@NonNull MysqlRegistryData mysqlRegistryData) throws SQLException {
        if (mysqlRegistryData == null) {
            throw new NullPointerException("mysqlRegistryData is marked non-null but is null");
        }
        String sql = "INSERT INTO t_ds_mysql_registry_data (`key`, data, type, last_term) VALUES (?, ?, ?, ?)";
        try (Connection connection = this.dataSource.getConnection();){
            long l;
            block14: {
                PreparedStatement preparedStatement = connection.prepareStatement(sql, 1);
                try {
                    preparedStatement.setString(1, mysqlRegistryData.getKey());
                    preparedStatement.setString(2, mysqlRegistryData.getData());
                    preparedStatement.setInt(3, mysqlRegistryData.getType());
                    preparedStatement.setLong(4, mysqlRegistryData.getLastTerm());
                    int insertCount = preparedStatement.executeUpdate();
                    ResultSet generatedKeys = preparedStatement.getGeneratedKeys();
                    if (insertCount < 1 || !generatedKeys.next()) {
                        throw new SQLException("Insert ephemeral data error, data: " + mysqlRegistryData);
                    }
                    l = generatedKeys.getLong(1);
                    if (preparedStatement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                preparedStatement.close();
            }
            return l;
        }
    }

    public long insertOrUpdatePersistentData(String key, String value) throws SQLException {
        String sql = "INSERT INTO t_ds_mysql_registry_data (`key`, data, type, last_term) VALUES (?, ?, ?, ?)ON DUPLICATE KEY UPDATE data=?, last_term=?";
        try (Connection connection = this.dataSource.getConnection();){
            long l;
            block13: {
                PreparedStatement preparedStatement = connection.prepareStatement(sql, 1);
                try {
                    long term = System.currentTimeMillis();
                    preparedStatement.setString(1, key);
                    preparedStatement.setString(2, value);
                    preparedStatement.setInt(3, DataType.PERSISTENT.getTypeValue());
                    preparedStatement.setLong(4, term);
                    preparedStatement.setString(5, value);
                    preparedStatement.setLong(6, term);
                    int insertCount = preparedStatement.executeUpdate();
                    ResultSet generatedKeys = preparedStatement.getGeneratedKeys();
                    if (insertCount < 1 || !generatedKeys.next()) {
                        throw new SQLException("Insert or update persistent data error");
                    }
                    l = generatedKeys.getLong(1);
                    if (preparedStatement == null) break block13;
                }
                catch (Throwable throwable) {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                preparedStatement.close();
            }
            return l;
        }
    }

    public void deleteEphemeralData(String key) throws SQLException {
        String sql = "DELETE from t_ds_mysql_registry_data where `key` = ? and type = ?";
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(sql);){
            preparedStatement.setString(1, key);
            preparedStatement.setInt(2, DataType.EPHEMERAL.getTypeValue());
            preparedStatement.execute();
        }
    }

    public void deleteEphemeralData(long ephemeralNodeId) throws SQLException {
        String sql = "DELETE from t_ds_mysql_registry_data where `id` = ?";
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(sql);){
            preparedStatement.setLong(1, ephemeralNodeId);
            preparedStatement.execute();
        }
    }

    public void deletePersistentData(String key) throws SQLException {
        String sql = "DELETE from t_ds_mysql_registry_data where `key` = ? and type = ?";
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(sql);){
            preparedStatement.setString(1, key);
            preparedStatement.setInt(2, DataType.PERSISTENT.getTypeValue());
            preparedStatement.execute();
        }
    }

    public void clearExpireLock() {
        String sql = "delete from t_ds_mysql_registry_lock where last_term < ?";
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(sql);){
            preparedStatement.setLong(1, System.currentTimeMillis() - this.expireTimeWindow);
            int i = preparedStatement.executeUpdate();
            if (i > 0) {
                logger.info("Clear expire lock, size: {}", (Object)i);
            }
        }
        catch (Exception ex) {
            logger.warn("Clear expire lock from mysql registry error", (Throwable)ex);
        }
    }

    public void clearExpireEphemeralDate() {
        String sql = "delete from t_ds_mysql_registry_data where last_term < ? and type = ?";
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(sql);){
            preparedStatement.setLong(1, System.currentTimeMillis() - this.expireTimeWindow);
            preparedStatement.setInt(2, DataType.EPHEMERAL.getTypeValue());
            int i = preparedStatement.executeUpdate();
            if (i > 0) {
                logger.info("clear expire ephemeral data, size:{}", (Object)i);
            }
        }
        catch (Exception ex) {
            logger.warn("Clear expire ephemeral data from mysql registry error", (Throwable)ex);
        }
    }

    /*
     * Exception decompiling
     */
    public MysqlRegistryData getData(String key) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public List<String> getChildren(String key) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean existKey(String key) throws SQLException {
        String sql = "SELECT 1 FROM t_ds_mysql_registry_data WHERE `key` = ?";
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(sql);){
            preparedStatement.setString(1, key);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (resultSet.next()) {
                    boolean bl = true;
                    return bl;
                }
            }
        }
        return false;
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public MysqlRegistryLock tryToAcquireLock(String key) throws SQLException {
        String sql = "INSERT INTO t_ds_mysql_registry_lock (`key`, lock_owner, last_term) VALUES (?, ?, ?)";
        try (Connection connection = this.dataSource.getConnection();){
            MysqlRegistryLock mysqlRegistryLock;
            block25: {
                ResultSet resultSet;
                PreparedStatement preparedStatement;
                block22: {
                    MysqlRegistryLock mysqlRegistryLock2;
                    block24: {
                        block23: {
                            preparedStatement = connection.prepareStatement(sql, 1);
                            preparedStatement.setString(1, key);
                            preparedStatement.setString(2, MysqlRegistryConstant.LOCK_OWNER);
                            preparedStatement.setLong(3, System.currentTimeMillis());
                            preparedStatement.executeUpdate();
                            resultSet = preparedStatement.getGeneratedKeys();
                            if (!resultSet.next()) break block22;
                            long newLockId = resultSet.getLong(1);
                            mysqlRegistryLock2 = this.getLockById(newLockId);
                            if (resultSet == null) break block23;
                            resultSet.close();
                        }
                        if (preparedStatement == null) break block24;
                        preparedStatement.close();
                    }
                    return mysqlRegistryLock2;
                }
                try {
                    block26: {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                        break block26;
                        {
                            catch (Throwable throwable) {
                                if (resultSet != null) {
                                    try {
                                        resultSet.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                        }
                    }
                    mysqlRegistryLock = null;
                    if (preparedStatement == null) break block25;
                }
                catch (Throwable throwable) {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    }
                    throw throwable;
                }
                preparedStatement.close();
            }
            return mysqlRegistryLock;
        }
        catch (SQLIntegrityConstraintViolationException e) {
            return null;
        }
    }

    /*
     * Loose catch block
     */
    public MysqlRegistryLock getLockById(long lockId) throws SQLException {
        String sql = "SELECT `id`, `key`, lock_owner, last_term, last_update_time, create_time FROM t_ds_mysql_registry_lock WHERE id = ?";
        try (Connection connection = this.dataSource.getConnection();){
            MysqlRegistryLock mysqlRegistryLock;
            block23: {
                ResultSet resultSet;
                PreparedStatement preparedStatement;
                block20: {
                    MysqlRegistryLock mysqlRegistryLock2;
                    block22: {
                        block21: {
                            preparedStatement = connection.prepareStatement(sql);
                            preparedStatement.setLong(1, lockId);
                            resultSet = preparedStatement.executeQuery();
                            if (!resultSet.next()) break block20;
                            mysqlRegistryLock2 = MysqlRegistryLock.builder().id(resultSet.getLong("id")).key(resultSet.getString("key")).lockOwner(resultSet.getString("lock_owner")).lastTerm(resultSet.getLong("last_term")).lastUpdateTime(resultSet.getTimestamp("last_update_time")).createTime(resultSet.getTimestamp("create_time")).build();
                            if (resultSet == null) break block21;
                            resultSet.close();
                        }
                        if (preparedStatement == null) break block22;
                        preparedStatement.close();
                    }
                    return mysqlRegistryLock2;
                }
                try {
                    block24: {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                        break block24;
                        {
                            catch (Throwable throwable) {
                                if (resultSet != null) {
                                    try {
                                        resultSet.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                        }
                    }
                    mysqlRegistryLock = null;
                    if (preparedStatement == null) break block23;
                }
                catch (Throwable throwable) {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    }
                    throw throwable;
                }
                preparedStatement.close();
            }
            return mysqlRegistryLock;
        }
    }

    public boolean releaseLock(long lockId) throws SQLException {
        String sql = "DELETE FROM t_ds_mysql_registry_lock WHERE id = ?";
        try (Connection connection = this.dataSource.getConnection();){
            boolean bl;
            block12: {
                PreparedStatement preparedStatement = connection.prepareStatement(sql);
                try {
                    preparedStatement.setLong(1, lockId);
                    int i = preparedStatement.executeUpdate();
                    boolean bl2 = bl = i > 0;
                    if (preparedStatement == null) break block12;
                }
                catch (Throwable throwable) {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                preparedStatement.close();
            }
            return bl;
        }
    }

    public boolean updateEphemeralDataTerm(Collection<Long> ephemeralDateIds) throws SQLException {
        StringBuilder sb = new StringBuilder("update t_ds_mysql_registry_data set `last_term` = ? where `id` IN (");
        Iterator<Long> iterator = ephemeralDateIds.iterator();
        for (int i = 0; i < ephemeralDateIds.size(); ++i) {
            sb.append(iterator.next());
            if (i == ephemeralDateIds.size() - 1) continue;
            sb.append(",");
        }
        sb.append(")");
        try (Connection connection = this.dataSource.getConnection();){
            boolean bl;
            block13: {
                PreparedStatement preparedStatement = connection.prepareStatement(sb.toString());
                try {
                    preparedStatement.setLong(1, System.currentTimeMillis());
                    boolean bl2 = bl = preparedStatement.executeUpdate() > 0;
                    if (preparedStatement == null) break block13;
                }
                catch (Throwable throwable) {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                preparedStatement.close();
            }
            return bl;
        }
    }

    public boolean updateLockTerm(List<Long> lockIds) throws SQLException {
        StringBuilder sb = new StringBuilder("update t_ds_mysql_registry_lock set `last_term` = ? where `id` IN (");
        Iterator<Long> iterator = lockIds.iterator();
        for (int i = 0; i < lockIds.size(); ++i) {
            sb.append(iterator.next());
            if (i == lockIds.size() - 1) continue;
            sb.append(",");
        }
        sb.append(")");
        try (Connection connection = this.dataSource.getConnection();){
            boolean bl;
            block13: {
                PreparedStatement preparedStatement = connection.prepareStatement(sb.toString());
                try {
                    preparedStatement.setLong(1, System.currentTimeMillis());
                    boolean bl2 = bl = preparedStatement.executeUpdate() > 0;
                    if (preparedStatement == null) break block13;
                }
                catch (Throwable throwable) {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                preparedStatement.close();
            }
            return bl;
        }
    }

    @Override
    public void close() throws Exception {
        HikariDataSource closedDatasource;
        if (!this.dataSource.isClosed() && (closedDatasource = this.dataSource) != null) {
            closedDatasource.close();
        }
    }
}

