/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.registry.mysql;

import java.sql.SQLException;
import java.time.Duration;
import java.util.Collection;
import javax.annotation.PostConstruct;
import lombok.NonNull;
import org.apache.dolphinscheduler.plugin.registry.mysql.MysqlOperator;
import org.apache.dolphinscheduler.plugin.registry.mysql.MysqlRegistryProperties;
import org.apache.dolphinscheduler.plugin.registry.mysql.task.EphemeralDateManager;
import org.apache.dolphinscheduler.plugin.registry.mysql.task.RegistryLockManager;
import org.apache.dolphinscheduler.plugin.registry.mysql.task.SubscribeDataManager;
import org.apache.dolphinscheduler.registry.api.ConnectionListener;
import org.apache.dolphinscheduler.registry.api.ConnectionState;
import org.apache.dolphinscheduler.registry.api.Registry;
import org.apache.dolphinscheduler.registry.api.RegistryException;
import org.apache.dolphinscheduler.registry.api.SubscribeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="registry", name={"type"}, havingValue="mysql")
public class MysqlRegistry
implements Registry {
    private static Logger LOGGER = LoggerFactory.getLogger(MysqlRegistry.class);
    private final MysqlRegistryProperties mysqlRegistryProperties;
    private final EphemeralDateManager ephemeralDateManager;
    private final SubscribeDataManager subscribeDataManager;
    private final RegistryLockManager registryLockManager;
    private final MysqlOperator mysqlOperator;

    public MysqlRegistry(MysqlRegistryProperties mysqlRegistryProperties) {
        this.mysqlOperator = new MysqlOperator(mysqlRegistryProperties);
        this.mysqlOperator.clearExpireLock();
        this.mysqlOperator.clearExpireEphemeralDate();
        this.mysqlRegistryProperties = mysqlRegistryProperties;
        this.ephemeralDateManager = new EphemeralDateManager(mysqlRegistryProperties, this.mysqlOperator);
        this.subscribeDataManager = new SubscribeDataManager(mysqlRegistryProperties, this.mysqlOperator);
        this.registryLockManager = new RegistryLockManager(mysqlRegistryProperties, this.mysqlOperator);
        LOGGER.info("Initialize Mysql Registry...");
    }

    @PostConstruct
    public void start() {
        LOGGER.info("Starting Mysql Registry...");
        this.ephemeralDateManager.start();
        this.subscribeDataManager.start();
        this.registryLockManager.start();
        LOGGER.info("Started Mysql Registry...");
    }

    public void connectUntilTimeout(@NonNull Duration timeout) throws RegistryException {
        long endTimeMills;
        if (timeout == null) {
            throw new NullPointerException("timeout is marked non-null but is null");
        }
        long beginTimeMillis = System.currentTimeMillis();
        long l = endTimeMills = timeout.getSeconds() <= 0L ? Long.MAX_VALUE : beginTimeMillis + timeout.toMillis();
        while (true) {
            if (System.currentTimeMillis() > endTimeMills) {
                throw new RegistryException(String.format("Cannot connect to mysql registry in %s s", timeout.getSeconds()));
            }
            if (this.ephemeralDateManager.getConnectionState() == ConnectionState.CONNECTED) {
                return;
            }
            try {
                Thread.sleep(this.mysqlRegistryProperties.getTermRefreshInterval().toMillis());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RegistryException("Cannot connect to mysql registry due to interrupted exception", (Throwable)e);
            }
        }
    }

    public boolean subscribe(String path, SubscribeListener listener) {
        this.subscribeDataManager.addListener(path, listener);
        return true;
    }

    public void unsubscribe(String path) {
        this.subscribeDataManager.removeListener(path);
    }

    public void addConnectionStateListener(ConnectionListener listener) {
        this.ephemeralDateManager.addConnectionListener(listener);
    }

    public String get(String key) {
        return this.subscribeDataManager.getData(key);
    }

    public void put(String key, String value, boolean deleteOnDisconnect) {
        try {
            if (deleteOnDisconnect) {
                this.ephemeralDateManager.insertOrUpdateEphemeralData(key, value);
            } else {
                this.mysqlOperator.insertOrUpdatePersistentData(key, value);
            }
        }
        catch (Exception ex) {
            throw new RegistryException(String.format("put key:%s, value:%s error", key, value), (Throwable)ex);
        }
    }

    public void delete(String key) {
        try {
            this.mysqlOperator.deleteEphemeralData(key);
            this.mysqlOperator.deletePersistentData(key);
        }
        catch (Exception e) {
            throw new RegistryException(String.format("Delete key: %s error", key), (Throwable)e);
        }
    }

    public Collection<String> children(String key) {
        try {
            return this.mysqlOperator.getChildren(key);
        }
        catch (SQLException e) {
            throw new RegistryException(String.format("Get key: %s children error", key), (Throwable)e);
        }
    }

    public boolean exists(String key) {
        try {
            return this.mysqlOperator.existKey(key);
        }
        catch (Exception e) {
            throw new RegistryException(String.format("Check key: %s exist error", key), (Throwable)e);
        }
    }

    public boolean acquireLock(String key) {
        try {
            this.registryLockManager.acquireLock(key);
            return true;
        }
        catch (RegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RegistryException(String.format("Acquire lock: %s error", key), (Throwable)e);
        }
    }

    public boolean releaseLock(String key) {
        this.registryLockManager.releaseLock(key);
        return true;
    }

    public void close() {
        LOGGER.info("Closing Mysql Registry...");
        try (EphemeralDateManager closed1 = this.ephemeralDateManager;
             SubscribeDataManager close2 = this.subscribeDataManager;
             RegistryLockManager close3 = this.registryLockManager;){
            MysqlOperator closed4 = this.mysqlOperator;
            if (closed4 != null) {
                closed4.close();
            }
        }
        catch (Exception e) {
            LOGGER.error("Close Mysql Registry error", (Throwable)e);
        }
        LOGGER.info("Closed Mysql Registry...");
    }
}

