/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.registry.mysql.task;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.dolphinscheduler.plugin.registry.mysql.MysqlOperator;
import org.apache.dolphinscheduler.plugin.registry.mysql.MysqlRegistryProperties;
import org.apache.dolphinscheduler.registry.api.ConnectionListener;
import org.apache.dolphinscheduler.registry.api.ConnectionState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EphemeralDateManager
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(EphemeralDateManager.class);
    private ConnectionState connectionState;
    private final MysqlOperator mysqlOperator;
    private final MysqlRegistryProperties registryProperties;
    private final List<ConnectionListener> connectionListeners = Collections.synchronizedList(new ArrayList());
    private final Set<Long> ephemeralDateIds = Collections.synchronizedSet(new HashSet());
    private final ScheduledExecutorService scheduledExecutorService;

    public EphemeralDateManager(MysqlRegistryProperties registryProperties, MysqlOperator mysqlOperator) {
        this.registryProperties = registryProperties;
        this.mysqlOperator = (MysqlOperator)Preconditions.checkNotNull((Object)mysqlOperator);
        this.scheduledExecutorService = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("EphemeralDateTermRefreshThread").setDaemon(true).build());
    }

    public void start() {
        this.scheduledExecutorService.scheduleWithFixedDelay(new EphemeralDateTermRefreshTask(this.mysqlOperator, this.connectionListeners, this.ephemeralDateIds), this.registryProperties.getTermRefreshInterval().toMillis(), this.registryProperties.getTermRefreshInterval().toMillis(), TimeUnit.MILLISECONDS);
    }

    public void addConnectionListener(ConnectionListener connectionListener) {
        this.connectionListeners.add(connectionListener);
    }

    public long insertOrUpdateEphemeralData(String key, String value) throws SQLException {
        long ephemeralId = this.mysqlOperator.insertOrUpdateEphemeralData(key, value);
        this.ephemeralDateIds.add(ephemeralId);
        return ephemeralId;
    }

    public ConnectionState getConnectionState() {
        return this.connectionState;
    }

    @Override
    public void close() throws SQLException {
        this.ephemeralDateIds.clear();
        this.connectionListeners.clear();
        this.scheduledExecutorService.shutdownNow();
        for (Long ephemeralDateId : this.ephemeralDateIds) {
            this.mysqlOperator.deleteEphemeralData(ephemeralDateId);
        }
    }

    class EphemeralDateTermRefreshTask
    implements Runnable {
        private final List<ConnectionListener> connectionListeners;
        private final Set<Long> ephemeralDateIds;
        private final MysqlOperator mysqlOperator;

        private EphemeralDateTermRefreshTask(MysqlOperator mysqlOperator, List<ConnectionListener> connectionListeners, Set<Long> ephemeralDateIds) {
            this.mysqlOperator = (MysqlOperator)Preconditions.checkNotNull((Object)mysqlOperator);
            this.connectionListeners = (List)Preconditions.checkNotNull(connectionListeners);
            this.ephemeralDateIds = (Set)Preconditions.checkNotNull(ephemeralDateIds);
        }

        @Override
        public void run() {
            try {
                ConnectionState currentConnectionState = this.getConnectionState();
                if (currentConnectionState == EphemeralDateManager.this.connectionState) {
                    return;
                }
                if (EphemeralDateManager.this.connectionState == ConnectionState.CONNECTED) {
                    if (currentConnectionState == ConnectionState.DISCONNECTED) {
                        EphemeralDateManager.this.connectionState = ConnectionState.DISCONNECTED;
                        this.triggerListener(ConnectionState.DISCONNECTED);
                    }
                } else if (EphemeralDateManager.this.connectionState == ConnectionState.DISCONNECTED) {
                    if (currentConnectionState == ConnectionState.CONNECTED) {
                        EphemeralDateManager.this.connectionState = ConnectionState.CONNECTED;
                        this.triggerListener(ConnectionState.RECONNECTED);
                    }
                } else if (EphemeralDateManager.this.connectionState == null) {
                    EphemeralDateManager.this.connectionState = currentConnectionState;
                    this.triggerListener(EphemeralDateManager.this.connectionState);
                }
            }
            catch (Exception e) {
                LOGGER.error("Mysql Registry connect state check task execute failed", (Throwable)e);
                EphemeralDateManager.this.connectionState = ConnectionState.DISCONNECTED;
                this.triggerListener(ConnectionState.DISCONNECTED);
            }
        }

        private ConnectionState getConnectionState() {
            try {
                if (this.ephemeralDateIds.isEmpty()) {
                    this.mysqlOperator.healthCheck();
                } else {
                    this.updateEphemeralDateTerm();
                }
                this.mysqlOperator.clearExpireEphemeralDate();
                return ConnectionState.CONNECTED;
            }
            catch (Exception ex) {
                return ConnectionState.DISCONNECTED;
            }
        }

        private void updateEphemeralDateTerm() throws SQLException {
            if (!this.mysqlOperator.updateEphemeralDataTerm(this.ephemeralDateIds)) {
                LOGGER.warn("Update mysql registry ephemeral data: {} term error", this.ephemeralDateIds);
            }
        }

        private void triggerListener(ConnectionState connectionState) {
            for (ConnectionListener connectionListener : this.connectionListeners) {
                connectionListener.onUpdate(connectionState);
            }
        }
    }
}

