/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.registry.mysql.task;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.dolphinscheduler.common.thread.ThreadUtils;
import org.apache.dolphinscheduler.plugin.registry.mysql.MysqlOperator;
import org.apache.dolphinscheduler.plugin.registry.mysql.MysqlRegistryProperties;
import org.apache.dolphinscheduler.plugin.registry.mysql.model.MysqlRegistryLock;
import org.apache.dolphinscheduler.registry.api.RegistryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistryLockManager
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(RegistryLockManager.class);
    private final MysqlOperator mysqlOperator;
    private final MysqlRegistryProperties registryProperties;
    private final Map<String, MysqlRegistryLock> lockHoldMap;
    private final ScheduledExecutorService lockTermUpdateThreadPool;

    public RegistryLockManager(MysqlRegistryProperties registryProperties, MysqlOperator mysqlOperator) {
        this.registryProperties = registryProperties;
        this.mysqlOperator = mysqlOperator;
        this.lockHoldMap = new ConcurrentHashMap<String, MysqlRegistryLock>();
        this.lockTermUpdateThreadPool = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("MysqlRegistryLockTermRefreshThread").setDaemon(true).build());
    }

    public void start() {
        this.lockTermUpdateThreadPool.scheduleWithFixedDelay(new LockTermRefreshTask(this.lockHoldMap, this.mysqlOperator), this.registryProperties.getTermRefreshInterval().toMillis(), this.registryProperties.getTermRefreshInterval().toMillis(), TimeUnit.MILLISECONDS);
    }

    public void acquireLock(String lockKey) throws RegistryException {
        this.lockHoldMap.computeIfAbsent(lockKey, key -> {
            MysqlRegistryLock mysqlRegistryLock;
            try {
                while ((mysqlRegistryLock = this.mysqlOperator.tryToAcquireLock(lockKey)) == null) {
                    logger.debug("Acquire the lock {} failed try again", key);
                    ThreadUtils.sleep((long)1000L);
                }
            }
            catch (SQLException e) {
                throw new RegistryException("Acquire the lock error", (Throwable)e);
            }
            return mysqlRegistryLock;
        });
    }

    public void releaseLock(String lockKey) {
        MysqlRegistryLock mysqlRegistryLock = this.lockHoldMap.get(lockKey);
        if (mysqlRegistryLock != null) {
            try {
                this.mysqlOperator.releaseLock(mysqlRegistryLock.getId());
                this.lockHoldMap.remove(lockKey);
            }
            catch (SQLException e) {
                throw new RegistryException(String.format("Release lock: %s error", lockKey), (Throwable)e);
            }
        }
    }

    @Override
    public void close() {
        this.lockTermUpdateThreadPool.shutdownNow();
        for (Map.Entry<String, MysqlRegistryLock> lockEntry : this.lockHoldMap.entrySet()) {
            this.releaseLock(lockEntry.getKey());
        }
    }

    static class LockTermRefreshTask
    implements Runnable {
        private final Map<String, MysqlRegistryLock> lockHoldMap;
        private final MysqlOperator mysqlOperator;

        @Override
        public void run() {
            try {
                if (this.lockHoldMap.isEmpty()) {
                    return;
                }
                List<Long> lockIds = this.lockHoldMap.values().stream().map(MysqlRegistryLock::getId).collect(Collectors.toList());
                if (!this.mysqlOperator.updateLockTerm(lockIds)) {
                    logger.warn("Update the lock: {} term failed.", lockIds);
                }
                this.mysqlOperator.clearExpireLock();
            }
            catch (Exception e) {
                logger.error("Update lock term error", (Throwable)e);
            }
        }

        @Generated
        private LockTermRefreshTask(Map<String, MysqlRegistryLock> lockHoldMap, MysqlOperator mysqlOperator) {
            this.lockHoldMap = lockHoldMap;
            this.mysqlOperator = mysqlOperator;
        }
    }
}

