/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.service.log;

import java.util.List;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.NetUtils;
import org.apache.dolphinscheduler.plugin.task.api.utils.LogUtils;
import org.apache.dolphinscheduler.remote.NettyRemotingClient;
import org.apache.dolphinscheduler.remote.command.Command;
import org.apache.dolphinscheduler.remote.command.log.GetAppIdRequestCommand;
import org.apache.dolphinscheduler.remote.command.log.GetAppIdResponseCommand;
import org.apache.dolphinscheduler.remote.command.log.GetLogBytesRequestCommand;
import org.apache.dolphinscheduler.remote.command.log.GetLogBytesResponseCommand;
import org.apache.dolphinscheduler.remote.command.log.RemoveTaskLogRequestCommand;
import org.apache.dolphinscheduler.remote.command.log.RemoveTaskLogResponseCommand;
import org.apache.dolphinscheduler.remote.command.log.RollViewLogRequestCommand;
import org.apache.dolphinscheduler.remote.command.log.RollViewLogResponseCommand;
import org.apache.dolphinscheduler.remote.command.log.ViewLogRequestCommand;
import org.apache.dolphinscheduler.remote.command.log.ViewLogResponseCommand;
import org.apache.dolphinscheduler.remote.config.NettyClientConfig;
import org.apache.dolphinscheduler.remote.exceptions.RemotingException;
import org.apache.dolphinscheduler.remote.utils.Host;
import org.apache.dolphinscheduler.service.utils.LoggerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class LogClient
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(LogClient.class);
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private final NettyRemotingClient client;
    private static final long LOG_REQUEST_TIMEOUT = 10000L;

    public LogClient() {
        NettyClientConfig nettyClientConfig = new NettyClientConfig();
        this.client = new NettyRemotingClient(nettyClientConfig);
        logger.info("Initialized LogClientService with config: {}", (Object)nettyClientConfig);
    }

    public String rollViewLog(String host, int port, String path, int skipLineNum, int limit) {
        logger.info("Roll view log from host : {}, port : {}, path {}, skipLineNum {} ,limit {}", new Object[]{host, port, path, skipLineNum, limit});
        RollViewLogRequestCommand request = new RollViewLogRequestCommand(path, skipLineNum, limit);
        Host address = new Host(host, port);
        try {
            Command command = request.convert2Command();
            Command response = this.client.sendSync(address, command, 10000L);
            if (response != null) {
                RollViewLogResponseCommand rollReviewLog = (RollViewLogResponseCommand)JSONUtils.parseObject((byte[])response.getBody(), RollViewLogResponseCommand.class);
                return rollReviewLog.getMsg();
            }
            return "Roll view log response is null";
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            logger.error("Roll view log from host : {}, port : {}, path {}, skipLineNum {} ,limit {} error, the current thread has been interrupted", new Object[]{host, port, path, skipLineNum, limit, ex});
            return "Roll view log error: " + ex.getMessage();
        }
        catch (Exception e) {
            logger.error("Roll view log from host : {}, port : {}, path {}, skipLineNum {} ,limit {} error", new Object[]{host, port, path, skipLineNum, limit, e});
            return "Roll view log error: " + e.getMessage();
        }
    }

    public String viewLog(String host, int port, String path) {
        logger.info("View log from host: {}, port: {}, logPath: {}", new Object[]{host, port, path});
        ViewLogRequestCommand request = new ViewLogRequestCommand(path);
        Host address = new Host(host, port);
        try {
            if (NetUtils.getHost().equals(host)) {
                return LoggerUtils.readWholeFileContent(request.getPath());
            }
            Command command = request.convert2Command();
            Command response = this.client.sendSync(address, command, 10000L);
            if (response != null) {
                ViewLogResponseCommand viewLog = (ViewLogResponseCommand)JSONUtils.parseObject((byte[])response.getBody(), ViewLogResponseCommand.class);
                return viewLog.getMsg();
            }
            return "View log response is null";
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            logger.error("View log from host: {}, port: {}, logPath: {} error, the current thread has been interrupted", new Object[]{host, port, path, ex});
            return "View log error: " + ex.getMessage();
        }
        catch (Exception e) {
            logger.error("View log from host: {}, port: {}, logPath: {} error", new Object[]{host, port, path, e});
            return "View log error: " + e.getMessage();
        }
    }

    public byte[] getLogBytes(String host, int port, String path) {
        logger.info("Get log bytes from host: {}, port: {}, logPath {}", new Object[]{host, port, path});
        GetLogBytesRequestCommand request = new GetLogBytesRequestCommand(path);
        Host address = new Host(host, port);
        try {
            Command command = request.convert2Command();
            Command response = this.client.sendSync(address, command, 10000L);
            if (response != null) {
                GetLogBytesResponseCommand getLog = (GetLogBytesResponseCommand)JSONUtils.parseObject((byte[])response.getBody(), GetLogBytesResponseCommand.class);
                return getLog.getData() == null ? EMPTY_BYTE_ARRAY : getLog.getData();
            }
            return EMPTY_BYTE_ARRAY;
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            logger.error("Get logSize from host: {}, port: {}, logPath: {} error, the current thread has been interrupted", new Object[]{host, port, path, ex});
            return EMPTY_BYTE_ARRAY;
        }
        catch (Exception e) {
            logger.error("Get logSize from host: {}, port: {}, logPath: {} error", new Object[]{host, port, path, e});
            return EMPTY_BYTE_ARRAY;
        }
    }

    public Boolean removeTaskLog(String host, int port, String path) {
        logger.info("Remove task log from host: {}, port: {}, logPath {}", new Object[]{host, port, path});
        RemoveTaskLogRequestCommand request = new RemoveTaskLogRequestCommand(path);
        Host address = new Host(host, port);
        try {
            Command command = request.convert2Command();
            Command response = this.client.sendSync(address, command, 10000L);
            if (response != null) {
                RemoveTaskLogResponseCommand taskLogResponse = (RemoveTaskLogResponseCommand)JSONUtils.parseObject((byte[])response.getBody(), RemoveTaskLogResponseCommand.class);
                return taskLogResponse.getStatus();
            }
            return false;
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            logger.error("Remove task log from host: {}, port: {} logPath: {} error, the current thread has been interrupted", new Object[]{host, port, path, ex});
            return false;
        }
        catch (Exception e) {
            logger.error("Remove task log from host: {}, port: {} logPath: {} error", new Object[]{host, port, path, e});
            return false;
        }
    }

    @Nullable
    public List<String> getAppIds(@NonNull String host, int port, @NonNull String taskLogFilePath) throws RemotingException, InterruptedException {
        if (host == null) {
            throw new NullPointerException("host is marked non-null but is null");
        }
        if (taskLogFilePath == null) {
            throw new NullPointerException("taskLogFilePath is marked non-null but is null");
        }
        logger.info("Begin to get appIds from worker: {}:{} taskLogPath: {}", new Object[]{host, port, taskLogFilePath});
        Host workerAddress = new Host(host, port);
        List appIds = null;
        if (NetUtils.getHost().equals(host)) {
            appIds = LogUtils.getAppIdsFromLogFile((String)taskLogFilePath);
        } else {
            Command command = new GetAppIdRequestCommand(taskLogFilePath).convert2Command();
            Command response = this.client.sendSync(workerAddress, command, 10000L);
            if (response != null) {
                GetAppIdResponseCommand responseCommand = (GetAppIdResponseCommand)JSONUtils.parseObject((byte[])response.getBody(), GetAppIdResponseCommand.class);
                appIds = responseCommand.getAppIds();
            }
        }
        logger.info("Get appIds: {} from worker: {}:{} taskLogPath: {}", new Object[]{appIds, host, port, taskLogFilePath});
        return appIds;
    }

    @Override
    public void close() {
        this.client.close();
        logger.info("LogClientService closed");
    }
}

