/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.service.utils;

import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.enums.ResUploadType;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonUtils {
    private static final Logger logger = LoggerFactory.getLogger(CommonUtils.class);
    private static final Base64 BASE64 = new Base64();

    protected CommonUtils() {
        throw new UnsupportedOperationException("Construct CommonUtils");
    }

    public static String getSystemEnvPath() {
        String envPath = PropertyUtils.getString((String)"dolphinscheduler.env.path");
        if (StringUtils.isEmpty((CharSequence)envPath)) {
            URL envDefaultPath = CommonUtils.class.getClassLoader().getResource("dolphinscheduler_env.sh");
            if (envDefaultPath != null) {
                envPath = envDefaultPath.getPath();
                logger.debug("env path :{}", (Object)envPath);
            } else {
                envPath = "/etc/profile";
            }
        }
        return envPath;
    }

    public static boolean isDevelopMode() {
        return PropertyUtils.getBoolean((String)"development.state", (boolean)true);
    }

    public static boolean isSetTaskDirToTenantEnable() {
        return PropertyUtils.getBoolean((String)"setTaskDirToTenant.enable", (boolean)false);
    }

    public static boolean getKerberosStartupState() {
        String resUploadStartupType = PropertyUtils.getUpperCaseString((String)"resource.storage.type");
        ResUploadType resUploadType = ResUploadType.valueOf((String)resUploadStartupType);
        Boolean kerberosStartupState = PropertyUtils.getBoolean((String)"hadoop.security.authentication.startup.state", (boolean)false);
        return resUploadType == ResUploadType.HDFS && kerberosStartupState != false;
    }

    public static boolean loadKerberosConf(Configuration configuration) throws IOException {
        return CommonUtils.loadKerberosConf(PropertyUtils.getString((String)"java.security.krb5.conf.path"), PropertyUtils.getString((String)"login.user.keytab.username"), PropertyUtils.getString((String)"login.user.keytab.path"), configuration);
    }

    public static void loadKerberosConf(String javaSecurityKrb5Conf, String loginUserKeytabUsername, String loginUserKeytabPath) throws IOException {
        CommonUtils.loadKerberosConf(javaSecurityKrb5Conf, loginUserKeytabUsername, loginUserKeytabPath, new Configuration());
    }

    public static boolean loadKerberosConf(String javaSecurityKrb5Conf, String loginUserKeytabUsername, String loginUserKeytabPath, Configuration configuration) throws IOException {
        if (CommonUtils.getKerberosStartupState()) {
            System.setProperty("java.security.krb5.conf", (String)StringUtils.defaultIfBlank((CharSequence)javaSecurityKrb5Conf, (CharSequence)PropertyUtils.getString((String)"java.security.krb5.conf.path")));
            configuration.set("hadoop.security.authentication", "kerberos");
            UserGroupInformation.setConfiguration((Configuration)configuration);
            UserGroupInformation.loginUserFromKeytab((String)((String)StringUtils.defaultIfBlank((CharSequence)loginUserKeytabUsername, (CharSequence)PropertyUtils.getString((String)"login.user.keytab.username"))), (String)((String)StringUtils.defaultIfBlank((CharSequence)loginUserKeytabPath, (CharSequence)PropertyUtils.getString((String)"login.user.keytab.path"))));
            return true;
        }
        return false;
    }

    public static String encodePassword(String password) {
        if (StringUtils.isEmpty((CharSequence)password)) {
            return "";
        }
        boolean encryptionEnable = PropertyUtils.getBoolean((String)"datasource.encryption.enable", (boolean)false);
        if (!encryptionEnable) {
            return password;
        }
        String salt = PropertyUtils.getString((String)"datasource.encryption.salt", (String)"!@#$%^&*");
        String passwordWithSalt = salt + new String(BASE64.encode(password.getBytes(StandardCharsets.UTF_8)));
        return new String(BASE64.encode(passwordWithSalt.getBytes(StandardCharsets.UTF_8)));
    }

    public static String decodePassword(String password) {
        if (StringUtils.isEmpty((CharSequence)password)) {
            return "";
        }
        boolean encryptionEnable = PropertyUtils.getBoolean((String)"datasource.encryption.enable", (boolean)false);
        if (!encryptionEnable) {
            return password;
        }
        String salt = PropertyUtils.getString((String)"datasource.encryption.salt", (String)"!@#$%^&*");
        String passwordWithSalt = new String(BASE64.decode(password), StandardCharsets.UTF_8);
        if (!passwordWithSalt.startsWith(salt)) {
            logger.warn("There is a password and salt mismatch: {} ", (Object)password);
            return password;
        }
        return new String(BASE64.decode(passwordWithSalt.substring(salt.length())), StandardCharsets.UTF_8);
    }
}

