/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.service.utils;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Date;
import lombok.Generated;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public final class LoggerUtils {
    private static final Logger logger = LoggerFactory.getLogger(LoggerUtils.class);

    public static String buildTaskId(Date firstSubmitTime, Long processDefineCode, int processDefineVersion, int processInstId, int taskId) {
        String firstSubmitTimeStr = DateUtils.format((Date)firstSubmitTime, (String)"yyyyMMdd", null);
        return String.format("%s=%s-%s-%s_%s-%s-%s", "taskAppId", "TASK", firstSubmitTimeStr, processDefineCode, processDefineVersion, processInstId, taskId);
    }

    public static String readWholeFileContent(String filePath) {
        String string;
        StringBuilder sb = new StringBuilder();
        BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(filePath)));
        try {
            String line;
            while ((line = br.readLine()) != null) {
                sb.append(line + "\r\n");
            }
            string = sb.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    br.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                logger.error("read file error", (Throwable)e);
                return "";
            }
        }
        br.close();
        return string;
    }

    public static void setWorkflowAndTaskInstanceIDMDC(Integer workflowInstanceId, Integer taskInstanceId) {
        LoggerUtils.setWorkflowInstanceIdMDC(workflowInstanceId);
        LoggerUtils.setTaskInstanceIdMDC(taskInstanceId);
    }

    public static void setWorkflowInstanceIdMDC(Integer workflowInstanceId) {
        MDC.put((String)"workflowInstanceId", (String)String.valueOf(workflowInstanceId));
    }

    public static void setTaskInstanceIdMDC(Integer taskInstanceId) {
        MDC.put((String)"taskInstanceId", (String)String.valueOf(taskInstanceId));
    }

    public static void removeWorkflowAndTaskInstanceIdMDC() {
        LoggerUtils.removeWorkflowInstanceIdMDC();
        LoggerUtils.removeTaskInstanceIdMDC();
    }

    public static void removeWorkflowInstanceIdMDC() {
        MDC.remove((String)"workflowInstanceId");
    }

    public static void removeTaskInstanceIdMDC() {
        MDC.remove((String)"taskInstanceId");
    }

    @Generated
    private LoggerUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

