/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.mlflow;

import java.util.HashMap;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.plugin.task.api.parameters.AbstractParameters;

public class MlflowParameters
extends AbstractParameters {
    private String params = "";
    private String mlflowJobType = "";
    private String mlflowProjectRepository;
    private String mlflowProjectVersion = "";
    private String automlTool = "FLAML";
    private String algorithm = "lightgbm";
    private String searchParams = "";
    private String dataPath;
    private String mlflowTaskType = "";
    private String experimentName = "Default";
    private String modelName = "";
    private String mlflowTrackingUri = "http://127.0.0.1:5000";
    private String deployType;
    private String deployModelKey;
    private String deployPort;

    public boolean checkParameters() {
        return StringUtils.isNotEmpty((CharSequence)this.mlflowTrackingUri);
    }

    public HashMap<String, String> getParamsMap() {
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        paramsMap.put("params", this.params);
        paramsMap.put("data_path", this.dataPath);
        paramsMap.put("experiment_name", this.experimentName);
        paramsMap.put("model_name", this.modelName);
        paramsMap.put("MLFLOW_TRACKING_URI", this.mlflowTrackingUri);
        switch (this.mlflowJobType) {
            case "BasicAlgorithm": {
                this.addParamsMapForBasicAlgorithm(paramsMap);
                break;
            }
            case "AutoML": {
                this.getParamsMapForAutoML(paramsMap);
            }
        }
        return paramsMap;
    }

    private void addParamsMapForBasicAlgorithm(HashMap<String, String> paramsMap) {
        paramsMap.put("algorithm", this.algorithm);
        paramsMap.put("search_params", this.searchParams);
        paramsMap.put("repo", "#Project-BasicAlgorithm");
        paramsMap.put("repo_version", "main");
    }

    private void getParamsMapForAutoML(HashMap<String, String> paramsMap) {
        paramsMap.put("automl_tool", this.automlTool);
        paramsMap.put("repo", "#Project-AutoML");
        paramsMap.put("repo_version", "main");
    }

    public Boolean isCustomProject() {
        return this.mlflowJobType.equals("CustomProject");
    }

    public String getModelKeyName(String tag) throws IllegalArgumentException {
        String imageName;
        if (this.deployModelKey.startsWith("runs:")) {
            imageName = this.deployModelKey.replace("runs:/", "");
        } else if (this.deployModelKey.startsWith("models:")) {
            imageName = this.deployModelKey.replace("models:/", "");
        } else {
            throw new IllegalArgumentException("model key must start with runs:/ or models:/ ");
        }
        imageName = imageName.replace("/", tag).toLowerCase();
        return imageName;
    }

    public String getContainerName() {
        return "ds-mlflow-" + this.getModelKeyName("-");
    }

    public boolean getIsDeployDocker() {
        if (StringUtils.isEmpty((CharSequence)this.deployType)) {
            return false;
        }
        return this.deployType.equals("DOCKER");
    }

    @Generated
    public MlflowParameters() {
    }

    @Generated
    public String getParams() {
        return this.params;
    }

    @Generated
    public String getMlflowJobType() {
        return this.mlflowJobType;
    }

    @Generated
    public String getMlflowProjectRepository() {
        return this.mlflowProjectRepository;
    }

    @Generated
    public String getMlflowProjectVersion() {
        return this.mlflowProjectVersion;
    }

    @Generated
    public String getAutomlTool() {
        return this.automlTool;
    }

    @Generated
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Generated
    public String getSearchParams() {
        return this.searchParams;
    }

    @Generated
    public String getDataPath() {
        return this.dataPath;
    }

    @Generated
    public String getMlflowTaskType() {
        return this.mlflowTaskType;
    }

    @Generated
    public String getExperimentName() {
        return this.experimentName;
    }

    @Generated
    public String getModelName() {
        return this.modelName;
    }

    @Generated
    public String getMlflowTrackingUri() {
        return this.mlflowTrackingUri;
    }

    @Generated
    public String getDeployType() {
        return this.deployType;
    }

    @Generated
    public String getDeployModelKey() {
        return this.deployModelKey;
    }

    @Generated
    public String getDeployPort() {
        return this.deployPort;
    }

    @Generated
    public void setParams(String params) {
        this.params = params;
    }

    @Generated
    public void setMlflowJobType(String mlflowJobType) {
        this.mlflowJobType = mlflowJobType;
    }

    @Generated
    public void setMlflowProjectRepository(String mlflowProjectRepository) {
        this.mlflowProjectRepository = mlflowProjectRepository;
    }

    @Generated
    public void setMlflowProjectVersion(String mlflowProjectVersion) {
        this.mlflowProjectVersion = mlflowProjectVersion;
    }

    @Generated
    public void setAutomlTool(String automlTool) {
        this.automlTool = automlTool;
    }

    @Generated
    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    @Generated
    public void setSearchParams(String searchParams) {
        this.searchParams = searchParams;
    }

    @Generated
    public void setDataPath(String dataPath) {
        this.dataPath = dataPath;
    }

    @Generated
    public void setMlflowTaskType(String mlflowTaskType) {
        this.mlflowTaskType = mlflowTaskType;
    }

    @Generated
    public void setExperimentName(String experimentName) {
        this.experimentName = experimentName;
    }

    @Generated
    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    @Generated
    public void setMlflowTrackingUri(String mlflowTrackingUri) {
        this.mlflowTrackingUri = mlflowTrackingUri;
    }

    @Generated
    public void setDeployType(String deployType) {
        this.deployType = deployType;
    }

    @Generated
    public void setDeployModelKey(String deployModelKey) {
        this.deployModelKey = deployModelKey;
    }

    @Generated
    public void setDeployPort(String deployPort) {
        this.deployPort = deployPort;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MlflowParameters)) {
            return false;
        }
        MlflowParameters other = (MlflowParameters)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$params = this.getParams();
        String other$params = other.getParams();
        if (this$params == null ? other$params != null : !this$params.equals(other$params)) {
            return false;
        }
        String this$mlflowJobType = this.getMlflowJobType();
        String other$mlflowJobType = other.getMlflowJobType();
        if (this$mlflowJobType == null ? other$mlflowJobType != null : !this$mlflowJobType.equals(other$mlflowJobType)) {
            return false;
        }
        String this$mlflowProjectRepository = this.getMlflowProjectRepository();
        String other$mlflowProjectRepository = other.getMlflowProjectRepository();
        if (this$mlflowProjectRepository == null ? other$mlflowProjectRepository != null : !this$mlflowProjectRepository.equals(other$mlflowProjectRepository)) {
            return false;
        }
        String this$mlflowProjectVersion = this.getMlflowProjectVersion();
        String other$mlflowProjectVersion = other.getMlflowProjectVersion();
        if (this$mlflowProjectVersion == null ? other$mlflowProjectVersion != null : !this$mlflowProjectVersion.equals(other$mlflowProjectVersion)) {
            return false;
        }
        String this$automlTool = this.getAutomlTool();
        String other$automlTool = other.getAutomlTool();
        if (this$automlTool == null ? other$automlTool != null : !this$automlTool.equals(other$automlTool)) {
            return false;
        }
        String this$algorithm = this.getAlgorithm();
        String other$algorithm = other.getAlgorithm();
        if (this$algorithm == null ? other$algorithm != null : !this$algorithm.equals(other$algorithm)) {
            return false;
        }
        String this$searchParams = this.getSearchParams();
        String other$searchParams = other.getSearchParams();
        if (this$searchParams == null ? other$searchParams != null : !this$searchParams.equals(other$searchParams)) {
            return false;
        }
        String this$dataPath = this.getDataPath();
        String other$dataPath = other.getDataPath();
        if (this$dataPath == null ? other$dataPath != null : !this$dataPath.equals(other$dataPath)) {
            return false;
        }
        String this$mlflowTaskType = this.getMlflowTaskType();
        String other$mlflowTaskType = other.getMlflowTaskType();
        if (this$mlflowTaskType == null ? other$mlflowTaskType != null : !this$mlflowTaskType.equals(other$mlflowTaskType)) {
            return false;
        }
        String this$experimentName = this.getExperimentName();
        String other$experimentName = other.getExperimentName();
        if (this$experimentName == null ? other$experimentName != null : !this$experimentName.equals(other$experimentName)) {
            return false;
        }
        String this$modelName = this.getModelName();
        String other$modelName = other.getModelName();
        if (this$modelName == null ? other$modelName != null : !this$modelName.equals(other$modelName)) {
            return false;
        }
        String this$mlflowTrackingUri = this.getMlflowTrackingUri();
        String other$mlflowTrackingUri = other.getMlflowTrackingUri();
        if (this$mlflowTrackingUri == null ? other$mlflowTrackingUri != null : !this$mlflowTrackingUri.equals(other$mlflowTrackingUri)) {
            return false;
        }
        String this$deployType = this.getDeployType();
        String other$deployType = other.getDeployType();
        if (this$deployType == null ? other$deployType != null : !this$deployType.equals(other$deployType)) {
            return false;
        }
        String this$deployModelKey = this.getDeployModelKey();
        String other$deployModelKey = other.getDeployModelKey();
        if (this$deployModelKey == null ? other$deployModelKey != null : !this$deployModelKey.equals(other$deployModelKey)) {
            return false;
        }
        String this$deployPort = this.getDeployPort();
        String other$deployPort = other.getDeployPort();
        return !(this$deployPort == null ? other$deployPort != null : !this$deployPort.equals(other$deployPort));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MlflowParameters;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $params = this.getParams();
        result = result * 59 + ($params == null ? 43 : $params.hashCode());
        String $mlflowJobType = this.getMlflowJobType();
        result = result * 59 + ($mlflowJobType == null ? 43 : $mlflowJobType.hashCode());
        String $mlflowProjectRepository = this.getMlflowProjectRepository();
        result = result * 59 + ($mlflowProjectRepository == null ? 43 : $mlflowProjectRepository.hashCode());
        String $mlflowProjectVersion = this.getMlflowProjectVersion();
        result = result * 59 + ($mlflowProjectVersion == null ? 43 : $mlflowProjectVersion.hashCode());
        String $automlTool = this.getAutomlTool();
        result = result * 59 + ($automlTool == null ? 43 : $automlTool.hashCode());
        String $algorithm = this.getAlgorithm();
        result = result * 59 + ($algorithm == null ? 43 : $algorithm.hashCode());
        String $searchParams = this.getSearchParams();
        result = result * 59 + ($searchParams == null ? 43 : $searchParams.hashCode());
        String $dataPath = this.getDataPath();
        result = result * 59 + ($dataPath == null ? 43 : $dataPath.hashCode());
        String $mlflowTaskType = this.getMlflowTaskType();
        result = result * 59 + ($mlflowTaskType == null ? 43 : $mlflowTaskType.hashCode());
        String $experimentName = this.getExperimentName();
        result = result * 59 + ($experimentName == null ? 43 : $experimentName.hashCode());
        String $modelName = this.getModelName();
        result = result * 59 + ($modelName == null ? 43 : $modelName.hashCode());
        String $mlflowTrackingUri = this.getMlflowTrackingUri();
        result = result * 59 + ($mlflowTrackingUri == null ? 43 : $mlflowTrackingUri.hashCode());
        String $deployType = this.getDeployType();
        result = result * 59 + ($deployType == null ? 43 : $deployType.hashCode());
        String $deployModelKey = this.getDeployModelKey();
        result = result * 59 + ($deployModelKey == null ? 43 : $deployModelKey.hashCode());
        String $deployPort = this.getDeployPort();
        result = result * 59 + ($deployPort == null ? 43 : $deployPort.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MlflowParameters(params=" + this.getParams() + ", mlflowJobType=" + this.getMlflowJobType() + ", mlflowProjectRepository=" + this.getMlflowProjectRepository() + ", mlflowProjectVersion=" + this.getMlflowProjectVersion() + ", automlTool=" + this.getAutomlTool() + ", algorithm=" + this.getAlgorithm() + ", searchParams=" + this.getSearchParams() + ", dataPath=" + this.getDataPath() + ", mlflowTaskType=" + this.getMlflowTaskType() + ", experimentName=" + this.getExperimentName() + ", modelName=" + this.getModelName() + ", mlflowTrackingUri=" + this.getMlflowTrackingUri() + ", deployType=" + this.getDeployType() + ", deployModelKey=" + this.getDeployModelKey() + ", deployPort=" + this.getDeployPort() + ")";
    }
}

