/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.support.migration;

import java.util.Optional;
import org.apache.dubbo.common.config.configcenter.DynamicConfiguration;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.cluster.support.migration.MigrationStep;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;

public class MigrationRule {
    private static final String DUBBO_SERVICEDISCOVERY_MIGRATION_KEY = "dubbo.application.service-discovery.migration";
    public static final String DUBBO_SERVICEDISCOVERY_MIGRATION_GROUP = "MIGRATION";
    public static final String RULE_KEY = ApplicationModel.getName() + ".migration";
    private static DynamicConfiguration configuration = null;
    private String key;
    private MigrationStep step = MigrationStep.FORCE_INTERFACE;

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public MigrationStep getStep() {
        return this.step;
    }

    public void setStep(MigrationStep step) {
        this.step = step;
    }

    public static MigrationRule parse(String rawRule) {
        if (null == configuration) {
            return MigrationRule.getMigrationRule(null);
        }
        if (StringUtils.isBlank((CharSequence)rawRule) || "INIT".equals(rawRule)) {
            String step = (String)configuration.getInternalProperty(DUBBO_SERVICEDISCOVERY_MIGRATION_KEY);
            return MigrationRule.getMigrationRule(step);
        }
        Constructor constructor = new Constructor(MigrationRule.class);
        Yaml yaml = new Yaml((BaseConstructor)constructor);
        return (MigrationRule)yaml.load(rawRule);
    }

    public static MigrationRule queryRule() {
        if (null == configuration) {
            return MigrationRule.getMigrationRule(null);
        }
        String rawRule = configuration.getConfig(RULE_KEY, DUBBO_SERVICEDISCOVERY_MIGRATION_GROUP);
        return MigrationRule.parse(rawRule);
    }

    private static MigrationRule getMigrationRule(String step) {
        MigrationRule rule = new MigrationRule();
        rule.setStep(Enum.valueOf(MigrationStep.class, StringUtils.isBlank((CharSequence)step) ? MigrationStep.APPLICATION_FIRST.name() : step));
        return rule;
    }

    static {
        Optional optional = ApplicationModel.getEnvironment().getDynamicConfiguration();
        optional.ifPresent(dynamicConfiguration -> {
            configuration = dynamicConfiguration;
        });
    }
}

