/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.router.mesh.route;

import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.configcenter.ConfigurationListener;
import org.apache.dubbo.common.config.configcenter.DynamicConfiguration;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.rpc.cluster.router.mesh.route.MeshAppRuleListener;
import org.apache.dubbo.rpc.cluster.router.mesh.route.MeshEnvListener;
import org.apache.dubbo.rpc.cluster.router.mesh.route.MeshEnvListenerFactory;
import org.apache.dubbo.rpc.cluster.router.mesh.route.MeshRuleRouter;

public final class MeshRuleManager {
    public static final Logger logger = LoggerFactory.getLogger(MeshRuleManager.class);
    private static final String MESH_RULE_DATA_ID_SUFFIX = ".MESHAPPRULE";
    private static final ConcurrentHashMap<String, MeshAppRuleListener> APP_RULE_LISTENERS = new ConcurrentHashMap();

    public static synchronized void subscribeAppRule(URL consumerUrl, String app) {
        MeshAppRuleListener meshAppRuleListener = new MeshAppRuleListener(app);
        String appRuleDataId = app + MESH_RULE_DATA_ID_SUFFIX;
        DynamicConfiguration configuration = consumerUrl.getOrDefaultModuleModel().getModelEnvironment().getDynamicConfiguration().orElse(null);
        Set envListenerFactories = ExtensionLoader.getExtensionLoader(MeshEnvListenerFactory.class).getSupportedExtensionInstances();
        Set envListeners = envListenerFactories.stream().map(MeshEnvListenerFactory::getListener).filter(Objects::nonNull).collect(Collectors.toSet());
        if (configuration == null && envListeners.stream().noneMatch(MeshEnvListener::isEnable)) {
            logger.warn("Doesn't support Configuration!");
            return;
        }
        if (configuration != null) {
            try {
                String rawConfig = configuration.getConfig(appRuleDataId, "dubbo", 5000L);
                if (rawConfig != null) {
                    meshAppRuleListener.receiveConfigInfo(rawConfig);
                }
            }
            catch (Throwable throwable) {
                logger.error("get MeshRuleManager app rule failed.", throwable);
            }
            configuration.addListener(appRuleDataId, "dubbo", (ConfigurationListener)meshAppRuleListener);
        }
        for (MeshEnvListener envListener : envListeners) {
            if (!envListener.isEnable()) continue;
            envListener.onSubscribe(app, meshAppRuleListener);
        }
        APP_RULE_LISTENERS.put(app, meshAppRuleListener);
    }

    public static void unsubscribeAppRule(URL consumerUrl, String app) {
        DynamicConfiguration configuration = consumerUrl.getOrDefaultModuleModel().getModelEnvironment().getDynamicConfiguration().orElse(null);
        String appRuleDataId = app + MESH_RULE_DATA_ID_SUFFIX;
        MeshAppRuleListener meshAppRuleListener = APP_RULE_LISTENERS.get(app);
        if (meshAppRuleListener != null && configuration != null) {
            configuration.removeListener(appRuleDataId, "dubbo", (ConfigurationListener)meshAppRuleListener);
        }
    }

    public static void register(String app, MeshRuleRouter subscriber) {
        MeshAppRuleListener meshAppRuleListener = APP_RULE_LISTENERS.get(app);
        if (meshAppRuleListener == null) {
            logger.warn("appRuleListener can't find when Router register");
            return;
        }
        meshAppRuleListener.register(subscriber);
    }

    public static void unregister(MeshRuleRouter subscriber) {
        Collection<MeshAppRuleListener> listeners = APP_RULE_LISTENERS.values();
        for (MeshAppRuleListener listener : listeners) {
            listener.unregister(subscriber);
        }
    }
}

