/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.support.wrapper;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.url.component.ServiceConfigURL;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.rpc.Exporter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Protocol;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.cluster.Cluster;
import org.apache.dubbo.rpc.cluster.ClusterInvoker;
import org.apache.dubbo.rpc.cluster.Directory;
import org.apache.dubbo.rpc.cluster.directory.StaticDirectory;
import org.apache.dubbo.rpc.listener.ExporterChangeListener;
import org.apache.dubbo.rpc.listener.InjvmExporterListener;

public class ScopeClusterInvoker<T>
implements ClusterInvoker<T>,
ExporterChangeListener {
    private final Object createLock = new Object();
    private Protocol protocolSPI;
    private final Directory<T> directory;
    private final Invoker<T> invoker;
    private final AtomicBoolean isExported;
    private volatile Invoker<T> injvmInvoker;
    private volatile InjvmExporterListener injvmExporterListener;
    private boolean peerFlag;
    private boolean injvmFlag;

    public ScopeClusterInvoker(Directory<T> directory, Invoker<T> invoker) {
        this.directory = directory;
        this.invoker = invoker;
        this.isExported = new AtomicBoolean(false);
        this.init();
    }

    public URL getUrl() {
        return this.directory.getConsumerUrl();
    }

    @Override
    public URL getRegistryUrl() {
        return this.directory.getUrl();
    }

    @Override
    public Directory<T> getDirectory() {
        return this.directory;
    }

    @Override
    public boolean isDestroyed() {
        return this.directory.isDestroyed();
    }

    public boolean isAvailable() {
        return this.isExported.get() || this.directory.isAvailable();
    }

    public void destroy() {
        if (this.injvmExporterListener != null) {
            this.injvmExporterListener.removeExporterChangeListener((ExporterChangeListener)this, this.getUrl().getServiceKey());
        }
        this.destroyInjvmInvoker();
        this.invoker.destroy();
    }

    public Class<T> getInterface() {
        return this.directory.getInterface();
    }

    public Result invoke(Invocation invocation) throws RpcException {
        if (this.peerFlag) {
            return this.invoker.invoke(invocation);
        }
        if (this.isInjvmExported()) {
            return this.injvmInvoker.invoke(invocation);
        }
        return this.invoker.invoke(invocation);
    }

    public void onExporterChangeExport(Exporter<?> exporter) {
        if (this.isExported.get()) {
            return;
        }
        if (this.getUrl().getServiceKey().equals(exporter.getInvoker().getUrl().getServiceKey()) && exporter.getInvoker().getUrl().getProtocol().equalsIgnoreCase("injvm")) {
            this.createInjvmInvoker();
            this.isExported.compareAndSet(false, true);
        }
    }

    public void onExporterChangeUnExport(Exporter<?> exporter) {
        if (this.getUrl().getServiceKey().equals(exporter.getInvoker().getUrl().getServiceKey()) && exporter.getInvoker().getUrl().getProtocol().equalsIgnoreCase("injvm")) {
            this.destroyInjvmInvoker();
            this.isExported.compareAndSet(true, false);
        }
    }

    public Invoker<?> getInvoker() {
        return this.invoker;
    }

    private void init() {
        Boolean peer = (Boolean)this.getUrl().getAttribute("peer");
        String isInjvm = this.getUrl().getParameter("injvm");
        if (peer != null && peer.booleanValue()) {
            this.peerFlag = true;
            return;
        }
        if (this.injvmInvoker == null && "injvm".equalsIgnoreCase(this.getRegistryUrl().getProtocol())) {
            this.injvmInvoker = this.invoker;
            this.isExported.compareAndSet(false, true);
            this.injvmFlag = true;
            return;
        }
        if (Boolean.TRUE.toString().equalsIgnoreCase(isInjvm) || "local".equalsIgnoreCase(this.getUrl().getParameter("scope"))) {
            this.injvmFlag = true;
        } else if (isInjvm == null) {
            this.injvmFlag = this.isNotRemoteOrGeneric();
        }
        this.protocolSPI = (Protocol)this.getUrl().getApplicationModel().getExtensionLoader(Protocol.class).getAdaptiveExtension();
        this.injvmExporterListener = (InjvmExporterListener)this.getUrl().getOrDefaultFrameworkModel().getBeanFactory().getBean(InjvmExporterListener.class);
        this.injvmExporterListener.addExporterChangeListener((ExporterChangeListener)this, this.getUrl().getServiceKey());
    }

    private boolean isNotRemoteOrGeneric() {
        return !"remote".equalsIgnoreCase(this.getUrl().getParameter("scope")) && !this.getUrl().getParameter("generic", false);
    }

    private boolean isInjvmExported() {
        boolean local;
        Boolean localInvoke = RpcContext.getServiceContext().getLocalInvoke();
        boolean isExportedValue = this.isExported.get();
        boolean bl = local = localInvoke != null && localInvoke != false;
        if (isExportedValue && local) {
            return true;
        }
        if (localInvoke != null && !localInvoke.booleanValue()) {
            return false;
        }
        if (!isExportedValue && ("local".equalsIgnoreCase(this.getUrl().getParameter("scope")) || Boolean.TRUE.toString().equalsIgnoreCase(this.getUrl().getParameter("injvm")) || local)) {
            throw new RpcException("Local service for " + this.getUrl().getServiceInterface() + " has not been exposed yet!");
        }
        return isExportedValue && this.injvmFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createInjvmInvoker() {
        if (this.injvmInvoker == null) {
            Object object = this.createLock;
            synchronized (object) {
                if (this.injvmInvoker == null) {
                    ServiceConfigURL url = new ServiceConfigURL("injvm", NetUtils.getLocalHost(), this.getUrl().getPort(), this.getInterface().getName(), this.getUrl().getParameters());
                    url = url.setScopeModel(this.getUrl().getScopeModel());
                    url = url.setServiceModel(this.getUrl().getServiceModel());
                    Invoker invoker = this.protocolSPI.refer(this.getInterface(), (URL)url);
                    ArrayList invokers = new ArrayList();
                    invokers.add(invoker);
                    this.injvmInvoker = Cluster.getCluster(url.getScopeModel(), "failover", false).join(new StaticDirectory((URL)url, invokers), true);
                }
            }
        }
    }

    private void destroyInjvmInvoker() {
        if (this.injvmInvoker != null) {
            this.injvmInvoker.destroy();
            this.injvmInvoker = null;
        }
    }
}

