/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.router.script.config;

import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.configcenter.ConfigChangeType;
import org.apache.dubbo.common.config.configcenter.ConfigChangedEvent;
import org.apache.dubbo.common.config.configcenter.ConfigurationListener;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.Holder;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.cluster.router.RouterSnapshotNode;
import org.apache.dubbo.rpc.cluster.router.script.ScriptStateRouter;
import org.apache.dubbo.rpc.cluster.router.script.config.model.ScriptRule;
import org.apache.dubbo.rpc.cluster.router.state.AbstractStateRouter;
import org.apache.dubbo.rpc.cluster.router.state.BitList;

public class AppScriptStateRouter<T>
extends AbstractStateRouter<T>
implements ConfigurationListener {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(AppScriptStateRouter.class);
    private static final String RULE_SUFFIX = ".script-router";
    private ScriptRule scriptRule;
    private ScriptStateRouter<T> scriptRouter;
    private String application;

    public AppScriptStateRouter(URL url) {
        super(url);
    }

    @Override
    protected BitList<Invoker<T>> doRoute(BitList<Invoker<T>> invokers, URL url, Invocation invocation, boolean needToPrintMessage, Holder<RouterSnapshotNode<T>> routerSnapshotNodeHolder, Holder<String> messageHolder) throws RpcException {
        if (this.scriptRouter == null || !this.scriptRule.isValid() || !this.scriptRule.isEnabled()) {
            if (needToPrintMessage) {
                messageHolder.set((Object)("Directly return from script router. Reason: Invokers from previous router is empty or script is not enabled. Script rule is: " + (this.scriptRule == null ? "null" : this.scriptRule.getRawRule())));
            }
            return invokers;
        }
        invokers = this.scriptRouter.route(invokers, url, invocation, needToPrintMessage, routerSnapshotNodeHolder);
        if (needToPrintMessage) {
            messageHolder.set((Object)((String)messageHolder.get()));
        }
        return invokers;
    }

    public synchronized void process(ConfigChangedEvent event) {
        if (logger.isDebugEnabled()) {
            logger.debug("Notification of script rule change, type is: " + event.getChangeType() + ", raw rule is:\n " + event.getContent());
        }
        try {
            if (event.getChangeType().equals((Object)ConfigChangeType.DELETED)) {
                this.scriptRule = null;
            } else {
                this.scriptRule = ScriptRule.parse(event.getContent());
                URL scriptUrl = this.getUrl().addParameter("type", StringUtils.isEmpty((String)this.scriptRule.getType()) ? "javascript" : this.scriptRule.getType()).addParameterAndEncoded("rule", this.scriptRule.getScript()).addParameter("force", this.scriptRule.isForce()).addParameter("runtime", this.scriptRule.isRuntime());
                this.scriptRouter = new ScriptStateRouter(scriptUrl);
            }
        }
        catch (Exception e) {
            logger.error("2-11", "Failed to parse the raw tag router rule", "", "Failed to parse the raw tag router rule and it will not take effect, please check if the rule matches with the template, the raw rule is:\n ", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notify(BitList<Invoker<T>> invokers) {
        if (CollectionUtils.isEmpty(invokers)) {
            return;
        }
        Invoker<T> invoker = invokers.get(0);
        URL url = invoker.getUrl();
        String providerApplication = url.getRemoteApplication();
        if (StringUtils.isEmpty((String)providerApplication)) {
            logger.error("2-12", "tag router get providerApplication is empty", "", "TagRouter must getConfig from or subscribe to a specific application, but the application in this TagRouter is not specified.");
            return;
        }
        AppScriptStateRouter appScriptStateRouter = this;
        synchronized (appScriptStateRouter) {
            if (!providerApplication.equals(this.application)) {
                if (StringUtils.isNotEmpty((String)this.application)) {
                    this.getRuleRepository().removeListener(this.application + RULE_SUFFIX, this);
                }
                String key = providerApplication + RULE_SUFFIX;
                this.getRuleRepository().addListener(key, this);
                this.application = providerApplication;
                String rawRule = this.getRuleRepository().getRule(key, "dubbo");
                if (StringUtils.isNotEmpty((String)rawRule)) {
                    this.process(new ConfigChangedEvent(key, "dubbo", rawRule));
                }
            }
        }
    }

    @Override
    public void stop() {
        if (StringUtils.isNotEmpty((String)this.application)) {
            this.getRuleRepository().removeListener(this.application + RULE_SUFFIX, this);
        }
    }

    public void setScriptRule(ScriptRule scriptRule) {
        this.scriptRule = scriptRule;
    }
}

