/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.event;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.dubbo.common.function.ThrowableConsumer;
import org.apache.dubbo.common.function.ThrowableFunction;
import org.apache.dubbo.event.Event;
import org.apache.dubbo.event.EventListener;

public abstract class GenericEventListener
implements EventListener<Event> {
    private final Method onEventMethod = this.findOnEventMethod();
    private final Map<Class<?>, Set<Method>> handleEventMethods = this.findHandleEventMethods();

    protected GenericEventListener() {
    }

    private Method findOnEventMethod() {
        return ThrowableFunction.execute(this.getClass(), listenerClass -> listenerClass.getMethod("onEvent", Event.class));
    }

    private Map<Class<?>, Set<Method>> findHandleEventMethods() {
        HashMap eventMethods = new HashMap();
        Stream.of(this.getClass().getMethods()).filter(this::isHandleEventMethod).forEach(method -> {
            Class<?> paramType = method.getParameterTypes()[0];
            Set methods = eventMethods.computeIfAbsent(paramType, key -> new LinkedHashSet());
            methods.add(method);
        });
        return eventMethods;
    }

    @Override
    public final void onEvent(Event event) {
        Class<?> eventClass = event.getClass();
        this.handleEventMethods.getOrDefault(eventClass, Collections.emptySet()).forEach(method -> ThrowableConsumer.execute(method, m -> m.invoke((Object)this, event)));
    }

    private boolean isHandleEventMethod(Method method) {
        if (this.onEventMethod.equals(method)) {
            return false;
        }
        if (!Modifier.isPublic(method.getModifiers())) {
            return false;
        }
        if (!Void.TYPE.equals(method.getReturnType())) {
            return false;
        }
        Class<?>[] exceptionTypes = method.getExceptionTypes();
        if (exceptionTypes.length > 0) {
            return false;
        }
        Class<?>[] paramTypes = method.getParameterTypes();
        if (paramTypes.length != 1) {
            return false;
        }
        return Event.class.isAssignableFrom(paramTypes[0]);
    }
}

