/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.event.listener;

import java.util.List;
import org.apache.dubbo.config.ServiceConfig;
import org.apache.dubbo.config.event.ServiceConfigExportedEvent;
import org.apache.dubbo.event.EventListener;
import org.apache.dubbo.metadata.ServiceNameMapping;

public class ServiceNameMappingListener
implements EventListener<ServiceConfigExportedEvent> {
    private final ServiceNameMapping serviceNameMapping = ServiceNameMapping.getDefaultExtension();

    public void onEvent(ServiceConfigExportedEvent event) {
        ServiceConfig serviceConfig = event.getServiceConfig();
        List exportedURLs = serviceConfig.getExportedUrls();
        exportedURLs.forEach(url -> {
            String serviceInterface = url.getServiceInterface();
            String group = url.getParameter("group");
            String version = url.getParameter("version");
            String protocol = url.getProtocol();
            this.serviceNameMapping.map(serviceInterface, group, version, protocol);
        });
    }
}

