/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.configcenter;

import java.util.Optional;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.Configuration;
import org.apache.dubbo.common.config.Environment;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.configcenter.ConfigurationListener;
import org.apache.dubbo.configcenter.DynamicConfigurationFactory;

public interface DynamicConfiguration
extends Configuration {
    public static final String DEFAULT_GROUP = "dubbo";

    default public void addListener(String key, ConfigurationListener listener) {
        this.addListener(key, DEFAULT_GROUP, listener);
    }

    default public void removeListener(String key, ConfigurationListener listener) {
        this.removeListener(key, DEFAULT_GROUP, listener);
    }

    public void addListener(String var1, String var2, ConfigurationListener var3);

    public void removeListener(String var1, String var2, ConfigurationListener var3);

    default public String getRule(String key, String group) {
        return this.getRule(key, group, -1L);
    }

    public String getRule(String var1, String var2, long var3) throws IllegalStateException;

    default public String getProperties(String key, String group) throws IllegalStateException {
        return this.getProperties(key, group, -1L);
    }

    public String getProperties(String var1, String var2, long var3) throws IllegalStateException;

    public static DynamicConfiguration getDynamicConfiguration() {
        Optional optional = Environment.getInstance().getDynamicConfiguration();
        return (DynamicConfiguration)optional.orElseGet(() -> ((DynamicConfigurationFactory)ExtensionLoader.getExtensionLoader(DynamicConfigurationFactory.class).getDefaultExtension()).getDynamicConfiguration(null));
    }

    public static String getRuleKey(URL url) {
        return url.getColonSeparatedKey();
    }
}

