/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.store;

import com.alibaba.fastjson.JSON;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.ClassUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.metadata.WritableMetadataService;
import org.apache.dubbo.metadata.definition.ServiceDefinitionBuilder;
import org.apache.dubbo.metadata.definition.model.FullServiceDefinition;
import org.apache.dubbo.rpc.support.ProtocolUtils;

public abstract class AbstractAbstractWritableMetadataService
implements WritableMetadataService {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void publishServiceDefinition(URL url) {
        if (SERVICE_INTERFACE_NAME.equals(url.getServiceInterface())) {
            return;
        }
        String side = (url = url.removeParameters(new String[]{"pid", "timestamp", "bind.ip", "bind.port", "timestamp"})).getParameter("side");
        if ("provider".equalsIgnoreCase(side)) {
            this.publishProviderServiceDefinition(url);
        } else {
            this.publishConsumerParameters(url);
        }
    }

    protected void publishProviderServiceDefinition(URL url) {
        String serviceDefinition = this.getServiceDefinition(url);
        if (!StringUtils.isBlank((CharSequence)serviceDefinition)) {
            this.publishServiceDefinition(url.getServiceKey(), serviceDefinition);
        }
    }

    protected String getServiceDefinition(URL exportedURL) {
        String json;
        block3: {
            String interfaceName = exportedURL.getParameter("interface");
            json = null;
            try {
                if (StringUtils.isNotEmpty((String)interfaceName) && !ProtocolUtils.isGeneric((String)exportedURL.getParameter("generic"))) {
                    Class interfaceClass = ClassUtils.forName((String)interfaceName);
                    FullServiceDefinition serviceDefinition = ServiceDefinitionBuilder.buildFullDefinition(interfaceClass, exportedURL.getParameters());
                    json = JSON.toJSONString((Object)serviceDefinition);
                }
            }
            catch (ClassNotFoundException e) {
                if (!this.logger.isErrorEnabled()) break block3;
                this.logger.error("The interface class[name : " + interfaceName + "] can't be found , providerUrl: " + exportedURL.toFullString());
            }
        }
        return json;
    }

    protected void publishConsumerParameters(URL url) {
    }

    protected void publishServiceDefinition(String key, String json) {
    }
}

