/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.rest.jaxrs;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.metadata.rest.AbstractAnnotatedMethodParameterProcessor;
import org.apache.dubbo.metadata.rest.RequestMetadata;
import org.apache.dubbo.metadata.rest.RestMethodMetadata;

public class DefaultValueParameterProcessor
extends AbstractAnnotatedMethodParameterProcessor {
    @Override
    public String getAnnotationName() {
        return "javax.ws.rs.DefaultValue";
    }

    @Override
    protected void process(String annotationValue, String defaultValue, Annotation annotation, Parameter parameter, int parameterIndex, Method method, RestMethodMetadata restMethodMetadata) {
        RequestMetadata requestMetadata = restMethodMetadata.getRequest();
        this.setDefaultValue(requestMetadata.getParams(), defaultValue, annotationValue);
        this.setDefaultValue(requestMetadata.getHeaders(), defaultValue, annotationValue);
    }

    private void setDefaultValue(Map<String, List<String>> source, String placeholderValue, String defaultValue) {
        block0: for (Map.Entry<String, List<String>> entry : source.entrySet()) {
            List<String> values = entry.getValue();
            int size = values.size();
            for (int i = 0; i < size; ++i) {
                String value = values.get(i);
                if (!placeholderValue.equals(value)) continue;
                values.set(i, defaultValue);
                break block0;
            }
        }
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }
}

