/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.aggregate;

public class Pane<T> {
    private final long intervalInMs;
    private volatile long startInMs;
    private volatile long endInMs;
    private T value;

    public Pane(long intervalInMs, long startInMs, T value) {
        this.intervalInMs = intervalInMs;
        this.startInMs = startInMs;
        this.endInMs = this.startInMs + this.intervalInMs;
        this.value = value;
    }

    public long getIntervalInMs() {
        return this.intervalInMs;
    }

    public long getStartInMs() {
        return this.startInMs;
    }

    public long getEndInMs() {
        return this.endInMs;
    }

    public T getValue() {
        return this.value;
    }

    public void setStartInMs(long newStartInMs) {
        this.startInMs = newStartInMs;
        this.endInMs = this.startInMs + this.intervalInMs;
    }

    public void setValue(T newData) {
        this.value = newData;
    }

    public boolean isTimeInWindow(long timeMillis) {
        return this.startInMs <= timeMillis && timeMillis < this.endInMs;
    }
}

