/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.configcenter.DynamicConfiguration;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.Assert;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.registry.AddressListener;
import org.apache.dubbo.registry.client.InstanceAddressURL;
import org.apache.dubbo.registry.client.OverrideInstanceAddressURL;
import org.apache.dubbo.registry.client.event.listener.ServiceInstancesChangedListener;
import org.apache.dubbo.registry.integration.AbstractConfiguratorListener;
import org.apache.dubbo.registry.integration.DynamicDirectory;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Protocol;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.cluster.Configurator;
import org.apache.dubbo.rpc.cluster.Directory;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class ServiceDiscoveryRegistryDirectory<T>
extends DynamicDirectory<T> {
    private static final Logger logger = LoggerFactory.getLogger(ServiceDiscoveryRegistryDirectory.class);
    private volatile Map<String, Invoker<T>> urlInvokerMap;
    private static final ConsumerConfigurationListener CONSUMER_CONFIGURATION_LISTENER = new ConsumerConfigurationListener();
    private volatile ReferenceConfigurationListener referenceConfigurationListener;
    private volatile boolean enableConfigurationListen = true;
    private volatile List<URL> originalUrls = null;
    private volatile Map<String, String> overrideQueryMap;
    private ServiceInstancesChangedListener listener;

    public ServiceDiscoveryRegistryDirectory(Class<T> serviceType, URL url) {
        super(serviceType, url);
    }

    @Override
    public void subscribe(URL url) {
        super.subscribe(url);
        if (((Boolean)ApplicationModel.getEnvironment().getConfiguration().convert(Boolean.class, "enable-configuration-listen", (Object)true)).booleanValue()) {
            this.enableConfigurationListen = true;
            CONSUMER_CONFIGURATION_LISTENER.addNotifyListener(this);
            this.referenceConfigurationListener = new ReferenceConfigurationListener(this, url);
        } else {
            this.enableConfigurationListen = false;
        }
    }

    @Override
    public void unSubscribe(URL url) {
        super.unSubscribe(url);
        this.originalUrls = null;
        if (((Boolean)ApplicationModel.getEnvironment().getConfiguration().convert(Boolean.class, "enable-configuration-listen", (Object)true)).booleanValue()) {
            CONSUMER_CONFIGURATION_LISTENER.removeNotifyListener(this);
            this.referenceConfigurationListener.stop();
        }
    }

    public boolean isAvailable() {
        if (this.isDestroyed()) {
            return false;
        }
        Map<String, Invoker<T>> localUrlInvokerMap = this.urlInvokerMap;
        if (localUrlInvokerMap != null && localUrlInvokerMap.size() > 0) {
            for (Invoker<T> invoker : new ArrayList<Invoker<T>>(localUrlInvokerMap.values())) {
                if (!invoker.isAvailable()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public synchronized void notify(List<URL> instanceUrls) {
        RpcContext.setRpcContext((URL)this.getConsumerUrl());
        ExtensionLoader addressListenerExtensionLoader = ExtensionLoader.getExtensionLoader(AddressListener.class);
        List supportedListeners = addressListenerExtensionLoader.getActivateExtension(this.getUrl(), (String[])null);
        if (supportedListeners != null && !supportedListeners.isEmpty()) {
            for (AddressListener addressListener : supportedListeners) {
                instanceUrls = addressListener.notify(instanceUrls, this.getConsumerUrl(), (Directory)this);
            }
        }
        this.refreshOverrideAndInvoker(instanceUrls);
    }

    private synchronized void refreshOverrideAndInvoker(List<URL> instanceUrls) {
        if (this.enableConfigurationListen) {
            this.overrideDirectoryUrl();
        }
        this.refreshInvoker(instanceUrls);
    }

    private void overrideDirectoryUrl() {
        this.overrideDirectoryUrl = this.directoryUrl;
        List<Configurator> localAppDynamicConfigurators = CONSUMER_CONFIGURATION_LISTENER.getConfigurators();
        this.doOverrideUrl(localAppDynamicConfigurators);
        if (this.referenceConfigurationListener != null) {
            List<Configurator> localDynamicConfigurators = this.referenceConfigurationListener.getConfigurators();
            this.doOverrideUrl(localDynamicConfigurators);
        }
    }

    private void doOverrideUrl(List<Configurator> configurators) {
        if (CollectionUtils.isNotEmpty(configurators)) {
            for (Configurator configurator : configurators) {
                this.overrideDirectoryUrl = configurator.configure(this.overrideDirectoryUrl);
                HashMap<String, String> newParams = new HashMap<String, String>(this.overrideDirectoryUrl.getParameters());
                this.directoryUrl.getParameters().forEach(newParams::remove);
                this.overrideQueryMap = newParams;
            }
        }
    }

    private InstanceAddressURL overrideWithConfigurator(InstanceAddressURL providerUrl) {
        providerUrl = this.overrideWithConfigurators(CONSUMER_CONFIGURATION_LISTENER.getConfigurators(), providerUrl);
        if (this.referenceConfigurationListener != null) {
            providerUrl = this.overrideWithConfigurators(this.referenceConfigurationListener.getConfigurators(), providerUrl);
        }
        return providerUrl;
    }

    private InstanceAddressURL overrideWithConfigurators(List<Configurator> configurators, InstanceAddressURL url) {
        if (CollectionUtils.isNotEmpty(configurators)) {
            OverrideInstanceAddressURL overrideInstanceAddressURL = new OverrideInstanceAddressURL(url);
            if (this.overrideQueryMap != null) {
                overrideInstanceAddressURL = (OverrideInstanceAddressURL)overrideInstanceAddressURL.addParameters(this.overrideQueryMap);
            }
            for (Configurator configurator : configurators) {
                overrideInstanceAddressURL = (OverrideInstanceAddressURL)configurator.configure((URL)overrideInstanceAddressURL);
            }
            return overrideInstanceAddressURL;
        }
        return url;
    }

    private void refreshInvoker(List<URL> invokerUrls) {
        Assert.notNull(invokerUrls, (String)"invokerUrls should not be null, use empty url list to clear address.");
        this.originalUrls = invokerUrls;
        if (invokerUrls.size() == 0) {
            this.forbidden = true;
            this.invokers = Collections.emptyList();
            this.routerChain.setInvokers(this.invokers);
            this.destroyAllInvokers();
            return;
        }
        this.forbidden = false;
        Map<String, Invoker<T>> oldUrlInvokerMap = this.urlInvokerMap;
        if (CollectionUtils.isEmpty(invokerUrls)) {
            return;
        }
        Map<String, Invoker<T>> newUrlInvokerMap = this.toInvokers(invokerUrls);
        if (CollectionUtils.isEmptyMap(newUrlInvokerMap)) {
            logger.error((Throwable)new IllegalStateException("Cannot create invokers from url address list (total " + invokerUrls.size() + ")"));
            return;
        }
        List<Invoker<T>> newInvokers = Collections.unmodifiableList(new ArrayList<Invoker<T>>(newUrlInvokerMap.values()));
        this.routerChain.setInvokers(newInvokers);
        this.invokers = this.multiGroup ? this.toMergeInvokerList(newInvokers) : newInvokers;
        this.urlInvokerMap = newUrlInvokerMap;
        if (oldUrlInvokerMap != null) {
            try {
                this.destroyUnusedInvokers(oldUrlInvokerMap, newUrlInvokerMap);
            }
            catch (Exception e) {
                logger.warn("destroyUnusedInvokers error. ", (Throwable)e);
            }
        }
        this.invokersChanged();
    }

    private Map<String, Invoker<T>> toInvokers(List<URL> urls) {
        HashMap<String, Invoker<T>> newUrlInvokerMap = new HashMap<String, Invoker<T>>();
        if (CollectionUtils.isEmpty(urls)) {
            return newUrlInvokerMap;
        }
        for (URL url : urls) {
            Invoker invoker;
            InstanceAddressURL instanceAddressURL = (InstanceAddressURL)url;
            if ("empty".equals(instanceAddressURL.getProtocol())) continue;
            if (!ExtensionLoader.getExtensionLoader(Protocol.class).hasExtension(instanceAddressURL.getProtocol())) {
                logger.error((Throwable)new IllegalStateException("Unsupported protocol " + instanceAddressURL.getProtocol() + " in notified url: " + (Object)((Object)instanceAddressURL) + " from registry " + this.getUrl().getAddress() + " to consumer " + NetUtils.getLocalHost() + ", supported protocol: " + ExtensionLoader.getExtensionLoader(Protocol.class).getSupportedExtensions()));
                continue;
            }
            instanceAddressURL.addConsumerParams(this.getConsumerUrl().getProtocolServiceKey(), this.queryMap);
            if (this.enableConfigurationListen) {
                instanceAddressURL = this.overrideWithConfigurator(instanceAddressURL);
            }
            Invoker invoker2 = invoker = this.urlInvokerMap == null ? null : this.urlInvokerMap.get(instanceAddressURL.getAddress());
            if (invoker == null || this.urlChanged(invoker, instanceAddressURL)) {
                try {
                    boolean enabled = true;
                    enabled = instanceAddressURL.hasParameter("disabled") ? !instanceAddressURL.getParameter("disabled", false) : instanceAddressURL.getParameter("enabled", true);
                    if (enabled) {
                        invoker = this.protocol.refer(this.serviceType, (URL)instanceAddressURL);
                    }
                }
                catch (Throwable t) {
                    logger.error("Failed to refer invoker for interface:" + this.serviceType + ",url:(" + (Object)((Object)instanceAddressURL) + ")" + t.getMessage(), t);
                }
                if (invoker == null) continue;
                newUrlInvokerMap.put(instanceAddressURL.getAddress(), invoker);
                continue;
            }
            newUrlInvokerMap.put(instanceAddressURL.getAddress(), invoker);
        }
        return newUrlInvokerMap;
    }

    private boolean urlChanged(Invoker<T> invoker, InstanceAddressURL newURL) {
        InstanceAddressURL oldURL = (InstanceAddressURL)invoker.getUrl();
        if (!newURL.getInstance().equals(oldURL.getInstance())) {
            return true;
        }
        if (oldURL instanceof OverrideInstanceAddressURL || newURL instanceof OverrideInstanceAddressURL) {
            if (!(oldURL instanceof OverrideInstanceAddressURL) || !(newURL instanceof OverrideInstanceAddressURL)) {
                return true;
            }
            if (!((OverrideInstanceAddressURL)oldURL).getOverrideParams().equals(((OverrideInstanceAddressURL)newURL).getOverrideParams())) {
                return true;
            }
        }
        return !oldURL.getMetadataInfo().getServiceInfo(this.getConsumerUrl().getProtocolServiceKey()).equals((Object)newURL.getMetadataInfo().getServiceInfo(this.getConsumerUrl().getProtocolServiceKey()));
    }

    private List<Invoker<T>> toMergeInvokerList(List<Invoker<T>> invokers) {
        return invokers;
    }

    @Override
    protected void destroyAllInvokers() {
        Map<String, Invoker<T>> localUrlInvokerMap = this.urlInvokerMap;
        if (localUrlInvokerMap != null) {
            for (Invoker<T> invoker : new ArrayList<Invoker<T>>(localUrlInvokerMap.values())) {
                try {
                    invoker.destroyAll();
                }
                catch (Throwable t) {
                    logger.warn("Failed to destroy service " + this.serviceKey + " to provider " + invoker.getUrl(), t);
                }
            }
            localUrlInvokerMap.clear();
        }
        this.invokers = null;
    }

    private void destroyUnusedInvokers(Map<String, Invoker<T>> oldUrlInvokerMap, Map<String, Invoker<T>> newUrlInvokerMap) {
        if (newUrlInvokerMap == null || newUrlInvokerMap.size() == 0) {
            this.destroyAllInvokers();
            return;
        }
        ArrayList<String> deleted = null;
        if (oldUrlInvokerMap != null) {
            Collection<Invoker<T>> newInvokers = newUrlInvokerMap.values();
            for (Map.Entry<String, Invoker<T>> entry : oldUrlInvokerMap.entrySet()) {
                if (newInvokers.contains(entry.getValue())) continue;
                if (deleted == null) {
                    deleted = new ArrayList<String>();
                }
                deleted.add(entry.getKey());
            }
        }
        if (deleted != null) {
            for (String addressKey : deleted) {
                Invoker<T> invoker;
                if (addressKey == null || (invoker = oldUrlInvokerMap.remove(addressKey)) == null) continue;
                try {
                    invoker.destroyAll();
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("destroy invoker[" + invoker.getUrl() + "] success. ");
                }
                catch (Exception e) {
                    logger.warn("destroy invoker[" + invoker.getUrl() + "] failed. " + e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private static class ConsumerConfigurationListener
    extends AbstractConfiguratorListener {
        private final List<ServiceDiscoveryRegistryDirectory<?>> listeners = new ArrayList();

        ConsumerConfigurationListener() {
        }

        void addNotifyListener(ServiceDiscoveryRegistryDirectory<?> listener) {
            if (this.listeners.size() == 0) {
                this.initWith(ApplicationModel.getApplication() + ".configurators");
            }
            this.listeners.add(listener);
        }

        void removeNotifyListener(ServiceDiscoveryRegistryDirectory<?> listener) {
            this.listeners.remove(listener);
            if (this.listeners.size() == 0) {
                this.stopListen(ApplicationModel.getApplication() + ".configurators");
            }
        }

        @Override
        protected void notifyOverrides() {
            this.listeners.forEach(listener -> {
                if (((ServiceDiscoveryRegistryDirectory)listener).originalUrls != null) {
                    URL backup = RpcContext.getContext().getConsumerUrl();
                    RpcContext.getContext().setConsumerUrl(listener.getConsumerUrl());
                    ((ServiceDiscoveryRegistryDirectory)listener).refreshOverrideAndInvoker(((ServiceDiscoveryRegistryDirectory)listener).originalUrls);
                    RpcContext.getContext().setConsumerUrl(backup);
                }
            });
        }
    }

    private static class ReferenceConfigurationListener
    extends AbstractConfiguratorListener {
        private final ServiceDiscoveryRegistryDirectory<?> directory;
        private final URL url;

        ReferenceConfigurationListener(ServiceDiscoveryRegistryDirectory<?> directory, URL url) {
            this.directory = directory;
            this.url = url;
            this.initWith(DynamicConfiguration.getRuleKey((URL)url) + ".configurators");
        }

        void stop() {
            this.stopListen(DynamicConfiguration.getRuleKey((URL)this.url) + ".configurators");
        }

        @Override
        protected void notifyOverrides() {
            if (((ServiceDiscoveryRegistryDirectory)this.directory).originalUrls != null) {
                URL backup = RpcContext.getContext().getConsumerUrl();
                RpcContext.getContext().setConsumerUrl(this.directory.getConsumerUrl());
                ((ServiceDiscoveryRegistryDirectory)this.directory).refreshOverrideAndInvoker(((ServiceDiscoveryRegistryDirectory)this.directory).originalUrls);
                RpcContext.getContext().setConsumerUrl(backup);
            }
        }
    }
}

