/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry;

import java.util.List;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.registry.NotifyListener;
import org.apache.dubbo.registry.Registry;
import org.apache.dubbo.registry.RegistryServiceListener;

public class ListenerRegistryWrapper
implements Registry {
    private static final Logger logger = LoggerFactory.getLogger(ListenerRegistryWrapper.class);
    private final Registry registry;
    private final List<RegistryServiceListener> listeners;

    public ListenerRegistryWrapper(Registry registry, List<RegistryServiceListener> listeners) {
        this.registry = registry;
        this.listeners = listeners;
    }

    public URL getUrl() {
        return this.registry.getUrl();
    }

    public boolean isAvailable() {
        return this.registry.isAvailable();
    }

    public void destroy() {
        this.registry.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(URL url) {
        try {
            this.registry.register(url);
        }
        finally {
            if (CollectionUtils.isNotEmpty(this.listeners)) {
                RuntimeException exception = null;
                for (RegistryServiceListener listener : this.listeners) {
                    if (listener == null) continue;
                    try {
                        listener.onRegister(url);
                    }
                    catch (RuntimeException t) {
                        logger.error(t.getMessage(), (Throwable)t);
                        exception = t;
                    }
                }
                if (exception != null) {
                    throw exception;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister(URL url) {
        try {
            this.registry.unregister(url);
        }
        finally {
            if (CollectionUtils.isNotEmpty(this.listeners)) {
                RuntimeException exception = null;
                for (RegistryServiceListener listener : this.listeners) {
                    if (listener == null) continue;
                    try {
                        listener.onUnregister(url);
                    }
                    catch (RuntimeException t) {
                        logger.error(t.getMessage(), (Throwable)t);
                        exception = t;
                    }
                }
                if (exception != null) {
                    throw exception;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void subscribe(URL url, NotifyListener listener) {
        try {
            this.registry.subscribe(url, listener);
        }
        finally {
            if (CollectionUtils.isNotEmpty(this.listeners)) {
                RuntimeException exception = null;
                for (RegistryServiceListener registryListener : this.listeners) {
                    if (registryListener == null) continue;
                    try {
                        registryListener.onSubscribe(url);
                    }
                    catch (RuntimeException t) {
                        logger.error(t.getMessage(), (Throwable)t);
                        exception = t;
                    }
                }
                if (exception != null) {
                    throw exception;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unsubscribe(URL url, NotifyListener listener) {
        try {
            this.registry.unsubscribe(url, listener);
        }
        finally {
            if (CollectionUtils.isNotEmpty(this.listeners)) {
                RuntimeException exception = null;
                for (RegistryServiceListener registryListener : this.listeners) {
                    if (registryListener == null) continue;
                    try {
                        registryListener.onUnsubscribe(url);
                    }
                    catch (RuntimeException t) {
                        logger.error(t.getMessage(), (Throwable)t);
                        exception = t;
                    }
                }
                if (exception != null) {
                    throw exception;
                }
            }
        }
    }

    @Override
    public List<URL> lookup(URL url) {
        return this.registry.lookup(url);
    }

    public Registry getRegistry() {
        return this.registry;
    }
}

