/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.integration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.URLBuilder;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.common.config.configcenter.ConfigurationListener;
import org.apache.dubbo.common.config.configcenter.DynamicConfiguration;
import org.apache.dubbo.common.constants.CommonConstants;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.timer.HashedWheelTimer;
import org.apache.dubbo.common.timer.TimerTask;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.NamedThreadFactory;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.common.utils.UrlUtils;
import org.apache.dubbo.registry.NotifyListener;
import org.apache.dubbo.registry.Registry;
import org.apache.dubbo.registry.RegistryFactory;
import org.apache.dubbo.registry.RegistryService;
import org.apache.dubbo.registry.integration.AbstractConfiguratorListener;
import org.apache.dubbo.registry.integration.RegistryDirectory;
import org.apache.dubbo.registry.integration.RegistryInvokerWrapper;
import org.apache.dubbo.registry.integration.RegistryProtocolListener;
import org.apache.dubbo.registry.retry.ReExportTask;
import org.apache.dubbo.registry.support.SkipFailbackWrapperException;
import org.apache.dubbo.rpc.Exporter;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Protocol;
import org.apache.dubbo.rpc.ProtocolServer;
import org.apache.dubbo.rpc.ProxyFactory;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.cluster.Cluster;
import org.apache.dubbo.rpc.cluster.Configurator;
import org.apache.dubbo.rpc.cluster.governance.GovernanceRuleRepository;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.ProviderModel;
import org.apache.dubbo.rpc.protocol.InvokerWrapper;

public class RegistryProtocol
implements Protocol {
    public static final String[] DEFAULT_REGISTER_PROVIDER_KEYS = new String[]{"application", "codec", "exchanger", "serialization", "cluster", "connections", "deprecated", "group", "loadbalance", "mock", "path", "timeout", "token", "version", "warmup", "weight", "timestamp", "dubbo", "release"};
    public static final String[] DEFAULT_REGISTER_CONSUMER_KEYS = new String[]{"application", "version", "group", "dubbo", "release"};
    private static final Logger logger = LoggerFactory.getLogger(RegistryProtocol.class);
    private final Map<URL, NotifyListener> overrideListeners = new ConcurrentHashMap<URL, NotifyListener>();
    private final Map<String, ServiceConfigurationListener> serviceConfigurationListeners = new ConcurrentHashMap<String, ServiceConfigurationListener>();
    private final ProviderConfigurationListener providerConfigurationListener = new ProviderConfigurationListener();
    private final ConcurrentMap<String, ExporterChangeableWrapper<?>> bounds = new ConcurrentHashMap();
    private Protocol protocol;
    private RegistryFactory registryFactory;
    private ProxyFactory proxyFactory;
    private ConcurrentMap<URL, ReExportTask> reExportFailedTasks = new ConcurrentHashMap<URL, ReExportTask>();
    private HashedWheelTimer retryTimer = new HashedWheelTimer((ThreadFactory)new NamedThreadFactory("DubboReexportTimer", true), 5000L, TimeUnit.MILLISECONDS, 128);
    private static RegistryProtocol INSTANCE;

    private static String[] getFilteredKeys(URL url) {
        Map params = url.getParameters();
        if (CollectionUtils.isNotEmptyMap((Map)params)) {
            return (String[])params.keySet().stream().filter(k -> k.startsWith(".")).toArray(String[]::new);
        }
        return new String[0];
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public void setRegistryFactory(RegistryFactory registryFactory) {
        this.registryFactory = registryFactory;
    }

    public void setProxyFactory(ProxyFactory proxyFactory) {
        this.proxyFactory = proxyFactory;
    }

    public int getDefaultPort() {
        return 9090;
    }

    public Map<URL, NotifyListener> getOverrideListeners() {
        return this.overrideListeners;
    }

    private void register(URL registryUrl, URL registeredProviderUrl) {
        Registry registry = this.registryFactory.getRegistry(registryUrl);
        registry.register(registeredProviderUrl);
    }

    private void registerStatedUrl(URL registryUrl, URL registeredProviderUrl, boolean registered) {
        ProviderModel model = ApplicationModel.getProviderModel((String)registeredProviderUrl.getServiceKey());
        model.addStatedUrl(new ProviderModel.RegisterStatedURL(registeredProviderUrl, registryUrl, registered));
    }

    public <T> Exporter<T> export(Invoker<T> originInvoker) throws RpcException {
        URL registryUrl = this.getRegistryUrl(originInvoker);
        URL providerUrl = this.getProviderUrl(originInvoker);
        URL overrideSubscribeUrl = this.getSubscribedOverrideUrl(providerUrl);
        OverrideListener overrideSubscribeListener = new OverrideListener(overrideSubscribeUrl, originInvoker);
        this.overrideListeners.put(overrideSubscribeUrl, overrideSubscribeListener);
        providerUrl = this.overrideUrlWithConfig(providerUrl, overrideSubscribeListener);
        ExporterChangeableWrapper<T> exporter = this.doLocalExport(originInvoker, providerUrl);
        Registry registry = this.getRegistry(originInvoker);
        URL registeredProviderUrl = this.getUrlToRegistry(providerUrl, registryUrl);
        boolean register = providerUrl.getParameter("register", true);
        if (register) {
            this.register(registryUrl, registeredProviderUrl);
        }
        this.registerStatedUrl(registryUrl, registeredProviderUrl, register);
        exporter.setRegisterUrl(registeredProviderUrl);
        exporter.setSubscribeUrl(overrideSubscribeUrl);
        registry.subscribe(overrideSubscribeUrl, overrideSubscribeListener);
        this.notifyExport(exporter);
        return new DestroyableExporter<T>(exporter);
    }

    private <T> void notifyExport(ExporterChangeableWrapper<T> exporter) {
        List listeners = ExtensionLoader.getExtensionLoader(RegistryProtocolListener.class).getActivateExtension(exporter.getOriginInvoker().getUrl(), "registry.protocol.listener");
        if (CollectionUtils.isNotEmpty((Collection)listeners)) {
            for (RegistryProtocolListener listener : listeners) {
                listener.onExport(this, exporter);
            }
        }
    }

    private URL overrideUrlWithConfig(URL providerUrl, OverrideListener listener) {
        providerUrl = this.providerConfigurationListener.overrideUrl(providerUrl);
        ServiceConfigurationListener serviceConfigurationListener = new ServiceConfigurationListener(providerUrl, listener);
        this.serviceConfigurationListeners.put(providerUrl.getServiceKey(), serviceConfigurationListener);
        return serviceConfigurationListener.overrideUrl(providerUrl);
    }

    private <T> ExporterChangeableWrapper<T> doLocalExport(Invoker<T> originInvoker, URL providerUrl) {
        String key = this.getCacheKey(originInvoker);
        return this.bounds.computeIfAbsent(key, s -> {
            InvokerDelegate invokerDelegate = new InvokerDelegate(originInvoker, providerUrl);
            return new ExporterChangeableWrapper(this.protocol.export(invokerDelegate), originInvoker);
        });
    }

    public <T> void reExport(Exporter<T> exporter, URL newInvokerUrl) {
        if (exporter instanceof ExporterChangeableWrapper) {
            ExporterChangeableWrapper exporterWrapper = (ExporterChangeableWrapper)exporter;
            Invoker originInvoker = exporterWrapper.getOriginInvoker();
            this.reExport(originInvoker, newInvokerUrl);
        }
    }

    public <T> void reExport(Invoker<T> originInvoker, URL newInvokerUrl) {
        block4: {
            String key = this.getCacheKey(originInvoker);
            ExporterChangeableWrapper exporter = (ExporterChangeableWrapper)this.bounds.get(key);
            URL registeredUrl = exporter.getRegisterUrl();
            URL registryUrl = this.getRegistryUrl(originInvoker);
            URL newProviderUrl = this.getUrlToRegistry(newInvokerUrl, registryUrl);
            InvokerDelegate<T> invokerDelegate = new InvokerDelegate<T>(originInvoker, newInvokerUrl);
            exporter.setExporter(this.protocol.export(invokerDelegate));
            if (!newProviderUrl.equals((Object)registeredUrl)) {
                try {
                    this.doReExport(originInvoker, exporter, registryUrl, registeredUrl, newProviderUrl);
                }
                catch (Exception e) {
                    ReExportTask oldTask = (ReExportTask)this.reExportFailedTasks.get(registeredUrl);
                    if (oldTask != null) {
                        return;
                    }
                    ReExportTask task = new ReExportTask(() -> this.doReExport(originInvoker, exporter, registryUrl, registeredUrl, newProviderUrl), registeredUrl, null);
                    oldTask = this.reExportFailedTasks.putIfAbsent(registeredUrl, task);
                    if (oldTask != null) break block4;
                    this.retryTimer.newTimeout((TimerTask)task, (long)registryUrl.getParameter("retry.period", 5000), TimeUnit.MILLISECONDS);
                }
            }
        }
    }

    private <T> void doReExport(Invoker<T> originInvoker, ExporterChangeableWrapper<T> exporter, URL registryUrl, URL oldProviderUrl, URL newProviderUrl) {
        if (this.getProviderUrl(originInvoker).getParameter("register", true)) {
            Registry registry = null;
            try {
                registry = this.getRegistry(originInvoker);
            }
            catch (Exception e) {
                throw new SkipFailbackWrapperException(e);
            }
            logger.info("Try to unregister old url: " + oldProviderUrl);
            registry.reExportUnregister(oldProviderUrl);
            logger.info("Try to register new url: " + newProviderUrl);
            registry.reExportRegister(newProviderUrl);
        }
        try {
            ProviderModel.RegisterStatedURL statedUrl = this.getStatedUrl(registryUrl, newProviderUrl);
            statedUrl.setProviderUrl(newProviderUrl);
            exporter.setRegisterUrl(newProviderUrl);
        }
        catch (Exception e) {
            throw new SkipFailbackWrapperException(e);
        }
    }

    private ProviderModel.RegisterStatedURL getStatedUrl(URL registryUrl, URL providerUrl) {
        ProviderModel providerModel = ApplicationModel.getServiceRepository().lookupExportedService(providerUrl.getServiceKey());
        List statedUrls = providerModel.getStatedUrl();
        return statedUrls.stream().filter(u -> u.getRegistryUrl().equals((Object)registryUrl) && u.getProviderUrl().getProtocol().equals(providerUrl.getProtocol())).findFirst().orElseThrow(() -> new IllegalStateException("There should have at least one registered url."));
    }

    protected Registry getRegistry(Invoker<?> originInvoker) {
        URL registryUrl = this.getRegistryUrl(originInvoker);
        return this.registryFactory.getRegistry(registryUrl);
    }

    protected URL getRegistryUrl(Invoker<?> originInvoker) {
        URL registryUrl = originInvoker.getUrl();
        if ("registry".equals(registryUrl.getProtocol())) {
            String protocol = registryUrl.getParameter("registry", "dubbo");
            registryUrl = registryUrl.setProtocol(protocol).removeParameter("registry");
        }
        return registryUrl;
    }

    protected URL getRegistryUrl(URL url) {
        return URLBuilder.from((URL)url).setProtocol(url.getParameter("registry", "dubbo")).removeParameter("registry").build();
    }

    private URL getUrlToRegistry(URL providerUrl, URL registryUrl) {
        if (!registryUrl.getParameter("simplified", false)) {
            return providerUrl.removeParameters(RegistryProtocol.getFilteredKeys(providerUrl)).removeParameters(new String[]{"monitor", "bind.ip", "bind.port", "qos.enable", "qos.host", "qos.port", "qos.accept.foreign.ip", "validation", "interfaces"});
        }
        String extraKeys = registryUrl.getParameter("extra-keys", "");
        if (!providerUrl.getPath().equals(providerUrl.getParameter("interface"))) {
            if (StringUtils.isNotEmpty((String)extraKeys)) {
                extraKeys = extraKeys + ",";
            }
            extraKeys = extraKeys + "interface";
        }
        String[] paramsToRegistry = this.getParamsToRegistry(DEFAULT_REGISTER_PROVIDER_KEYS, CommonConstants.COMMA_SPLIT_PATTERN.split(extraKeys));
        return URL.valueOf((URL)providerUrl, (String[])paramsToRegistry, (String[])providerUrl.getParameter("methods", (String[])null));
    }

    private URL getSubscribedOverrideUrl(URL registeredProviderUrl) {
        return registeredProviderUrl.setProtocol("provider").addParameters(new String[]{"category", "configurators", "check", String.valueOf(false)});
    }

    private URL getProviderUrl(Invoker<?> originInvoker) {
        String export = originInvoker.getUrl().getParameterAndDecoded("export");
        if (export == null || export.length() == 0) {
            throw new IllegalArgumentException("The registry export url is null! registry: " + originInvoker.getUrl());
        }
        return URL.valueOf((String)export);
    }

    private String getCacheKey(Invoker<?> originInvoker) {
        URL providerUrl = this.getProviderUrl(originInvoker);
        String key = providerUrl.removeParameters(new String[]{"dynamic", "enabled"}).toFullString();
        return key;
    }

    public <T> Invoker<T> refer(Class<T> type, URL url) throws RpcException {
        url = this.getRegistryUrl(url);
        Registry registry = this.registryFactory.getRegistry(url);
        if (RegistryService.class.equals(type)) {
            return this.proxyFactory.getInvoker((Object)registry, type, url);
        }
        Map qs = StringUtils.parseQueryString((String)url.getParameterAndDecoded("refer"));
        String group = (String)qs.get("group");
        if (group != null && group.length() > 0 && (CommonConstants.COMMA_SPLIT_PATTERN.split(group).length > 1 || "*".equals(group))) {
            return this.doRefer(Cluster.getCluster((String)"mergeable"), registry, type, url);
        }
        Cluster cluster = Cluster.getCluster((String)((String)qs.get("cluster")));
        return this.doRefer(cluster, registry, type, url);
    }

    private <T> Invoker<T> doRefer(Cluster cluster, Registry registry, Class<T> type, URL url) {
        RegistryDirectory<T> directory = new RegistryDirectory<T>(type, url);
        directory.setRegistry(registry);
        directory.setProtocol(this.protocol);
        HashMap parameters = new HashMap(directory.getConsumerUrl().getParameters());
        URL subscribeUrl = new URL("consumer", (String)parameters.remove("register.ip"), 0, type.getName(), parameters);
        if (directory.isShouldRegister()) {
            directory.setRegisteredConsumerUrl(subscribeUrl);
            registry.register(directory.getRegisteredConsumerUrl());
        }
        directory.buildRouterChain(subscribeUrl);
        directory.subscribe(RegistryProtocol.toSubscribeUrl(subscribeUrl));
        Invoker invoker = cluster.join(directory);
        List<RegistryProtocolListener> listeners = this.findRegistryProtocolListeners(url);
        if (CollectionUtils.isEmpty(listeners)) {
            return invoker;
        }
        RegistryInvokerWrapper<T> registryInvokerWrapper = new RegistryInvokerWrapper<T>(directory, cluster, invoker);
        for (RegistryProtocolListener listener : listeners) {
            listener.onRefer(this, (Invoker<?>)registryInvokerWrapper);
        }
        return registryInvokerWrapper;
    }

    public <T> void reRefer(Invoker<T> invoker, URL newSubscribeUrl) {
        if (!(invoker instanceof RegistryInvokerWrapper)) {
            return;
        }
        RegistryInvokerWrapper invokerWrapper = (RegistryInvokerWrapper)invoker;
        URL oldSubscribeUrl = invokerWrapper.getUrl();
        RegistryDirectory directory = invokerWrapper.getDirectory();
        Registry registry = directory.getRegistry();
        registry.unregister(directory.getRegisteredConsumerUrl());
        directory.unSubscribe(RegistryProtocol.toSubscribeUrl(oldSubscribeUrl));
        directory.setRegisteredConsumerUrl(newSubscribeUrl);
        registry.register(directory.getRegisteredConsumerUrl());
        directory.buildRouterChain(newSubscribeUrl);
        directory.subscribe(RegistryProtocol.toSubscribeUrl(newSubscribeUrl));
        invokerWrapper.setInvoker(invokerWrapper.getCluster().join(directory));
    }

    private static URL toSubscribeUrl(URL url) {
        return url.addParameter("category", "providers,configurators,routers");
    }

    private List<RegistryProtocolListener> findRegistryProtocolListeners(URL url) {
        return ExtensionLoader.getExtensionLoader(RegistryProtocolListener.class).getActivateExtension(url, "registry.protocol.listener");
    }

    public String[] getParamsToRegistry(String[] defaultKeys, String[] additionalParameterKeys) {
        int additionalLen = additionalParameterKeys.length;
        String[] registryParams = new String[defaultKeys.length + additionalLen];
        System.arraycopy(defaultKeys, 0, registryParams, 0, defaultKeys.length);
        System.arraycopy(additionalParameterKeys, 0, registryParams, defaultKeys.length, additionalLen);
        return registryParams;
    }

    public void destroy() {
        List listeners = ExtensionLoader.getExtensionLoader(RegistryProtocolListener.class).getLoadedExtensionInstances();
        if (CollectionUtils.isNotEmpty((Collection)listeners)) {
            for (RegistryProtocolListener listener : listeners) {
                listener.onDestroy();
            }
        }
        ArrayList exporters = new ArrayList(this.bounds.values());
        for (Exporter exporter : exporters) {
            exporter.unexport();
        }
        this.bounds.clear();
        ((GovernanceRuleRepository)ExtensionLoader.getExtensionLoader(GovernanceRuleRepository.class).getDefaultExtension()).removeListener(ApplicationModel.getApplication() + ".configurators", (ConfigurationListener)this.providerConfigurationListener);
    }

    public List<ProtocolServer> getServers() {
        return this.protocol.getServers();
    }

    private static URL getConfigedInvokerUrl(List<Configurator> configurators, URL url) {
        if (configurators != null && configurators.size() > 0) {
            for (Configurator configurator : configurators) {
                url = configurator.configure(url);
            }
        }
        return url;
    }

    public RegistryProtocol() {
        INSTANCE = this;
    }

    public static RegistryProtocol getRegistryProtocol() {
        if (INSTANCE == null) {
            ExtensionLoader.getExtensionLoader(Protocol.class).getExtension("registry");
        }
        return INSTANCE;
    }

    private class ExporterChangeableWrapper<T>
    implements Exporter<T> {
        private final ExecutorService executor = Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory("Exporter-Unexport", true));
        private final Invoker<T> originInvoker;
        private Exporter<T> exporter;
        private URL subscribeUrl;
        private URL registerUrl;

        public ExporterChangeableWrapper(Exporter<T> exporter, Invoker<T> originInvoker) {
            this.exporter = exporter;
            this.originInvoker = originInvoker;
        }

        public Invoker<T> getOriginInvoker() {
            return this.originInvoker;
        }

        public Invoker<T> getInvoker() {
            return this.exporter.getInvoker();
        }

        public void setExporter(Exporter<T> exporter) {
            this.exporter = exporter;
        }

        public void unexport() {
            String key = RegistryProtocol.this.getCacheKey(this.originInvoker);
            RegistryProtocol.this.bounds.remove(key);
            Registry registry = RegistryProtocol.this.getRegistry(this.originInvoker);
            try {
                registry.unregister(this.registerUrl);
            }
            catch (Throwable t) {
                logger.warn(t.getMessage(), t);
            }
            try {
                NotifyListener listener = (NotifyListener)RegistryProtocol.this.overrideListeners.remove(this.subscribeUrl);
                registry.unsubscribe(this.subscribeUrl, listener);
                ((GovernanceRuleRepository)ExtensionLoader.getExtensionLoader(GovernanceRuleRepository.class).getDefaultExtension()).removeListener(this.subscribeUrl.getServiceKey() + ".configurators", (ConfigurationListener)RegistryProtocol.this.serviceConfigurationListeners.get(this.subscribeUrl.getServiceKey()));
            }
            catch (Throwable t) {
                logger.warn(t.getMessage(), t);
            }
            this.executor.submit(() -> {
                try {
                    int timeout = ConfigurationUtils.getServerShutdownTimeout();
                    if (timeout > 0) {
                        logger.info("Waiting " + timeout + "ms for registry to notify all consumers before unexport. Usually, this is called when you use dubbo API");
                        Thread.sleep(timeout);
                    }
                    this.exporter.unexport();
                }
                catch (Throwable t) {
                    logger.warn(t.getMessage(), t);
                }
            });
        }

        public void setSubscribeUrl(URL subscribeUrl) {
            this.subscribeUrl = subscribeUrl;
        }

        public void setRegisterUrl(URL registerUrl) {
            this.registerUrl = registerUrl;
        }

        public URL getRegisterUrl() {
            return this.registerUrl;
        }
    }

    private class ProviderConfigurationListener
    extends AbstractConfiguratorListener {
        public ProviderConfigurationListener() {
            this.initWith(ApplicationModel.getApplication() + ".configurators");
        }

        private <T> URL overrideUrl(URL providerUrl) {
            return RegistryProtocol.getConfigedInvokerUrl(this.configurators, providerUrl);
        }

        @Override
        protected void notifyOverrides() {
            RegistryProtocol.this.overrideListeners.values().forEach(listener -> ((OverrideListener)listener).doOverrideIfNecessary());
        }
    }

    private class ServiceConfigurationListener
    extends AbstractConfiguratorListener {
        private URL providerUrl;
        private OverrideListener notifyListener;

        public ServiceConfigurationListener(URL providerUrl, OverrideListener notifyListener) {
            this.providerUrl = providerUrl;
            this.notifyListener = notifyListener;
            this.initWith(DynamicConfiguration.getRuleKey((URL)providerUrl) + ".configurators");
        }

        private <T> URL overrideUrl(URL providerUrl) {
            return RegistryProtocol.getConfigedInvokerUrl(this.configurators, providerUrl);
        }

        @Override
        protected void notifyOverrides() {
            this.notifyListener.doOverrideIfNecessary();
        }
    }

    private class OverrideListener
    implements NotifyListener {
        private final URL subscribeUrl;
        private final Invoker originInvoker;
        private List<Configurator> configurators;

        public OverrideListener(URL subscribeUrl, Invoker originalInvoker) {
            this.subscribeUrl = subscribeUrl;
            this.originInvoker = originalInvoker;
        }

        @Override
        public synchronized void notify(List<URL> urls) {
            logger.debug("original override urls: " + urls);
            List<URL> matchedUrls = this.getMatchedUrls(urls, this.subscribeUrl.addParameter("category", "configurators"));
            logger.debug("subscribe url: " + this.subscribeUrl + ", override urls: " + matchedUrls);
            if (matchedUrls.isEmpty()) {
                return;
            }
            this.configurators = Configurator.toConfigurators((List)UrlUtils.classifyUrls(matchedUrls, UrlUtils::isConfigurator)).orElse(this.configurators);
            this.doOverrideIfNecessary();
        }

        public synchronized void doOverrideIfNecessary() {
            Invoker invoker = this.originInvoker instanceof InvokerDelegate ? ((InvokerDelegate)this.originInvoker).getInvoker() : this.originInvoker;
            URL originUrl = RegistryProtocol.this.getProviderUrl(invoker);
            String key = RegistryProtocol.this.getCacheKey(this.originInvoker);
            ExporterChangeableWrapper exporter = (ExporterChangeableWrapper)RegistryProtocol.this.bounds.get(key);
            if (exporter == null) {
                logger.warn((Throwable)new IllegalStateException("error state, exporter should not be null"));
                return;
            }
            URL currentUrl = exporter.getInvoker().getUrl();
            URL newUrl = RegistryProtocol.getConfigedInvokerUrl(this.configurators, currentUrl);
            newUrl = RegistryProtocol.getConfigedInvokerUrl(RegistryProtocol.this.providerConfigurationListener.getConfigurators(), newUrl);
            newUrl = RegistryProtocol.getConfigedInvokerUrl(((ServiceConfigurationListener)RegistryProtocol.this.serviceConfigurationListeners.get(originUrl.getServiceKey())).getConfigurators(), newUrl);
            if (!currentUrl.equals((Object)newUrl)) {
                RegistryProtocol.this.reExport(this.originInvoker, newUrl);
                logger.info("exported provider url changed, origin url: " + originUrl + ", old export url: " + currentUrl + ", new export url: " + newUrl);
            }
        }

        private List<URL> getMatchedUrls(List<URL> configuratorUrls, URL currentSubscribe) {
            ArrayList<URL> result = new ArrayList<URL>();
            Iterator<URL> iterator = configuratorUrls.iterator();
            while (iterator.hasNext()) {
                URL url;
                URL overrideUrl = url = iterator.next();
                if (url.getParameter("category") == null && "override".equals(url.getProtocol())) {
                    overrideUrl = url.addParameter("category", "configurators");
                }
                if (!UrlUtils.isMatch((URL)currentSubscribe, (URL)overrideUrl)) continue;
                result.add(url);
            }
            return result;
        }
    }

    private static class DestroyableExporter<T>
    implements Exporter<T> {
        private Exporter<T> exporter;

        public DestroyableExporter(Exporter<T> exporter) {
            this.exporter = exporter;
        }

        public Invoker<T> getInvoker() {
            return this.exporter.getInvoker();
        }

        public void unexport() {
            this.exporter.unexport();
        }
    }

    public static class InvokerDelegate<T>
    extends InvokerWrapper<T> {
        private final Invoker<T> invoker;

        public InvokerDelegate(Invoker<T> invoker, URL url) {
            super(invoker, url);
            this.invoker = invoker;
        }

        public Invoker<T> getInvoker() {
            if (this.invoker instanceof InvokerDelegate) {
                return ((InvokerDelegate)this.invoker).getInvoker();
            }
            return this.invoker;
        }
    }
}

