/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.zookeeper;

import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.configcenter.ConfigItem;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.ConcurrentHashMapUtils;
import org.apache.dubbo.common.utils.ConcurrentHashSet;
import org.apache.dubbo.remoting.zookeeper.ChildListener;
import org.apache.dubbo.remoting.zookeeper.DataListener;
import org.apache.dubbo.remoting.zookeeper.StateListener;
import org.apache.dubbo.remoting.zookeeper.ZookeeperClient;

public abstract class AbstractZookeeperClient<TargetDataListener, TargetChildListener>
implements ZookeeperClient {
    protected static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(AbstractZookeeperClient.class);
    protected int DEFAULT_CONNECTION_TIMEOUT_MS = 30000;
    protected int DEFAULT_SESSION_TIMEOUT_MS = 60000;
    private final URL url;
    private final Set<StateListener> stateListeners = new CopyOnWriteArraySet<StateListener>();
    private final ConcurrentMap<String, ConcurrentMap<ChildListener, TargetChildListener>> childListeners = new ConcurrentHashMap<String, ConcurrentMap<ChildListener, TargetChildListener>>();
    private final ConcurrentMap<String, ConcurrentMap<DataListener, TargetDataListener>> listeners = new ConcurrentHashMap<String, ConcurrentMap<DataListener, TargetDataListener>>();
    private volatile boolean closed = false;
    private final Set<String> persistentExistNodePath = new ConcurrentHashSet();

    public AbstractZookeeperClient(URL url) {
        this.url = url;
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    @Override
    public void delete(String path) {
        this.persistentExistNodePath.remove(path);
        this.deletePath(path);
    }

    @Override
    public void create(String path, boolean ephemeral, boolean faultTolerant) {
        int i;
        if (!ephemeral) {
            if (this.persistentExistNodePath.contains(path)) {
                return;
            }
            if (this.checkExists(path)) {
                this.persistentExistNodePath.add(path);
                return;
            }
        }
        if ((i = path.lastIndexOf(47)) > 0) {
            this.create(path.substring(0, i), false, true);
        }
        if (ephemeral) {
            this.createEphemeral(path, faultTolerant);
        } else {
            this.createPersistent(path, faultTolerant);
            this.persistentExistNodePath.add(path);
        }
    }

    @Override
    public void addStateListener(StateListener listener) {
        this.stateListeners.add(listener);
    }

    @Override
    public void removeStateListener(StateListener listener) {
        this.stateListeners.remove(listener);
    }

    public Set<StateListener> getSessionListeners() {
        return this.stateListeners;
    }

    @Override
    public List<String> addChildListener(String path, ChildListener listener) {
        ConcurrentMap listeners = (ConcurrentMap)ConcurrentHashMapUtils.computeIfAbsent(this.childListeners, (Object)path, k -> new ConcurrentHashMap());
        Object targetListener = ConcurrentHashMapUtils.computeIfAbsent((ConcurrentMap)listeners, (Object)listener, k -> this.createTargetChildListener(path, (ChildListener)k));
        return this.addTargetChildListener(path, targetListener);
    }

    @Override
    public void addDataListener(String path, DataListener listener) {
        this.addDataListener(path, listener, null);
    }

    @Override
    public void addDataListener(String path, DataListener listener, Executor executor) {
        ConcurrentMap dataListenerMap = (ConcurrentMap)ConcurrentHashMapUtils.computeIfAbsent(this.listeners, (Object)path, k -> new ConcurrentHashMap());
        Object targetListener = ConcurrentHashMapUtils.computeIfAbsent((ConcurrentMap)dataListenerMap, (Object)listener, k -> this.createTargetDataListener(path, (DataListener)k));
        this.addTargetDataListener(path, targetListener, executor);
    }

    @Override
    public void removeDataListener(String path, DataListener listener) {
        Object targetListener;
        ConcurrentMap dataListenerMap = (ConcurrentMap)this.listeners.get(path);
        if (dataListenerMap != null && (targetListener = dataListenerMap.remove(listener)) != null) {
            this.removeTargetDataListener(path, targetListener);
        }
    }

    @Override
    public void removeChildListener(String path, ChildListener listener) {
        Object targetListener;
        ConcurrentMap listeners = (ConcurrentMap)this.childListeners.get(path);
        if (listeners != null && (targetListener = listeners.remove(listener)) != null) {
            this.removeTargetChildListener(path, targetListener);
        }
    }

    protected void stateChanged(int state) {
        for (StateListener sessionListener : this.getSessionListeners()) {
            sessionListener.stateChanged(state);
        }
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            this.doClose();
        }
        catch (Exception e) {
            logger.warn("1-35", "", "", e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void createOrUpdate(String path, String content, boolean ephemeral) {
        int i = path.lastIndexOf(47);
        if (i > 0) {
            this.create(path.substring(0, i), false, true);
        }
        if (ephemeral) {
            this.createOrUpdateEphemeral(path, content);
        } else {
            this.createOrUpdatePersistent(path, content);
        }
    }

    @Override
    public void createOrUpdate(String path, String content, boolean ephemeral, Integer version) {
        int i = path.lastIndexOf(47);
        if (i > 0) {
            this.create(path.substring(0, i), false, true);
        }
        if (ephemeral) {
            this.createOrUpdateEphemeral(path, content, version);
        } else {
            this.createOrUpdatePersistent(path, content, version);
        }
    }

    @Override
    public String getContent(String path) {
        if (!this.checkExists(path)) {
            return null;
        }
        return this.doGetContent(path);
    }

    @Override
    public ConfigItem getConfigItem(String path) {
        return this.doGetConfigItem(path);
    }

    protected void doClose() {
        this.stateListeners.clear();
    }

    protected abstract void createPersistent(String var1, boolean var2);

    protected abstract void createEphemeral(String var1, boolean var2);

    protected abstract void createPersistent(String var1, String var2, boolean var3);

    protected abstract void createEphemeral(String var1, String var2, boolean var3);

    protected abstract void update(String var1, String var2, int var3);

    protected abstract void update(String var1, String var2);

    protected abstract void createOrUpdatePersistent(String var1, String var2);

    protected abstract void createOrUpdateEphemeral(String var1, String var2);

    protected abstract void createOrUpdatePersistent(String var1, String var2, Integer var3);

    protected abstract void createOrUpdateEphemeral(String var1, String var2, Integer var3);

    @Override
    public abstract boolean checkExists(String var1);

    protected abstract TargetChildListener createTargetChildListener(String var1, ChildListener var2);

    protected abstract List<String> addTargetChildListener(String var1, TargetChildListener var2);

    protected abstract TargetDataListener createTargetDataListener(String var1, DataListener var2);

    protected abstract void addTargetDataListener(String var1, TargetDataListener var2);

    protected abstract void addTargetDataListener(String var1, TargetDataListener var2, Executor var3);

    protected abstract void removeTargetDataListener(String var1, TargetDataListener var2);

    protected abstract void removeTargetChildListener(String var1, TargetChildListener var2);

    protected abstract String doGetContent(String var1);

    protected abstract ConfigItem doGetConfigItem(String var1);

    protected abstract void deletePath(String var1);
}

