/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.filter;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.ConfigUtils;
import org.apache.dubbo.common.utils.NamedThreadFactory;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.support.AccessLogData;

@Activate(group={"provider"}, value={"accesslog"})
public class AccessLogFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(AccessLogFilter.class);
    private static final String LOG_KEY = "dubbo.accesslog";
    private static final String LINE_SEPARATOR = "line.separator";
    private static final int LOG_MAX_BUFFER = 5000;
    private static final long LOG_OUTPUT_INTERVAL = 5000L;
    private static final String FILE_DATE_FORMAT = "yyyyMMdd";
    private static final DateFormat FILE_NAME_FORMATTER = new SimpleDateFormat("yyyyMMdd");
    private static final Map<String, Queue<AccessLogData>> LOG_ENTRIES = new ConcurrentHashMap<String, Queue<AccessLogData>>();
    private static final ScheduledExecutorService LOG_SCHEDULED = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("Dubbo-Access-Log", true));

    public AccessLogFilter() {
        LOG_SCHEDULED.scheduleWithFixedDelay(this::writeLogToFile, 5000L, 5000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public Result invoke(Invoker<?> invoker, Invocation inv) throws RpcException {
        try {
            String accessLogKey = invoker.getUrl().getParameter("accesslog");
            if (ConfigUtils.isNotEmpty((String)accessLogKey)) {
                AccessLogData logData = AccessLogData.newLogData();
                logData.buildAccessLogData(invoker, inv);
                this.log(accessLogKey, logData);
            }
        }
        catch (Throwable t) {
            logger.warn("Exception in AccessLogFilter of service(" + invoker + " -> " + inv + ")", t);
        }
        return invoker.invoke(inv);
    }

    private void log(String accessLog, AccessLogData accessLogData) {
        Queue logQueue = LOG_ENTRIES.computeIfAbsent(accessLog, k -> new ConcurrentLinkedQueue());
        if (logQueue.size() < 5000) {
            logQueue.add(accessLogData);
        } else {
            logger.warn("AccessLog buffer is full. Do a force writing to file to clear buffer.");
            this.writeLogQueueToFile(accessLog, logQueue);
            logQueue.add(accessLogData);
        }
    }

    private void writeLogQueueToFile(String accessLog, Queue<AccessLogData> logQueue) {
        try {
            if (ConfigUtils.isDefault((String)accessLog)) {
                this.processWithServiceLogger(logQueue);
            } else {
                File file = new File(accessLog);
                this.createIfLogDirAbsent(file);
                if (logger.isDebugEnabled()) {
                    logger.debug("Append log to " + accessLog);
                }
                this.renameFile(file);
                this.processWithAccessKeyLogger(logQueue, file);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void writeLogToFile() {
        if (!LOG_ENTRIES.isEmpty()) {
            for (Map.Entry<String, Queue<AccessLogData>> entry : LOG_ENTRIES.entrySet()) {
                String accessLog = entry.getKey();
                Queue<AccessLogData> logQueue = entry.getValue();
                this.writeLogQueueToFile(accessLog, logQueue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processWithAccessKeyLogger(Queue<AccessLogData> logQueue, File file) throws IOException {
        FileWriter writer = new FileWriter(file, true);
        try {
            while (!logQueue.isEmpty()) {
                writer.write(logQueue.poll().getLogMessage());
                writer.write(System.getProperty(LINE_SEPARATOR));
            }
        }
        finally {
            writer.flush();
            writer.close();
        }
    }

    private void processWithServiceLogger(Queue<AccessLogData> logQueue) {
        while (!logQueue.isEmpty()) {
            AccessLogData logData = logQueue.poll();
            LoggerFactory.getLogger((String)("dubbo.accesslog." + logData.getServiceName())).info(logData.getLogMessage());
        }
    }

    private void createIfLogDirAbsent(File file) {
        File dir = file.getParentFile();
        if (null != dir && !dir.exists()) {
            dir.mkdirs();
        }
    }

    private void renameFile(File file) {
        String last;
        String now;
        if (file.exists() && !(now = FILE_NAME_FORMATTER.format(new Date())).equals(last = FILE_NAME_FORMATTER.format(new Date(file.lastModified())))) {
            File archive = new File(file.getAbsolutePath() + "." + last);
            file.renameTo(archive);
        }
    }
}

