/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.listener;

import java.util.List;
import java.util.function.Consumer;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.rpc.Exporter;
import org.apache.dubbo.rpc.ExporterListener;
import org.apache.dubbo.rpc.Invoker;

public class ListenerExporterWrapper<T>
implements Exporter<T> {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(ListenerExporterWrapper.class);
    private final Exporter<T> exporter;
    private final List<ExporterListener> listeners;

    public ListenerExporterWrapper(Exporter<T> exporter, List<ExporterListener> listeners) {
        if (exporter == null) {
            throw new IllegalArgumentException("exporter == null");
        }
        this.exporter = exporter;
        this.listeners = listeners;
        this.listenerEvent(listener -> listener.exported(this));
    }

    @Override
    public Invoker<T> getInvoker() {
        return this.exporter.getInvoker();
    }

    @Override
    public void unexport() {
        try {
            this.exporter.unexport();
        }
        finally {
            this.listenerEvent(listener -> listener.unexported(this));
        }
    }

    private void listenerEvent(Consumer<ExporterListener> consumer) {
        if (CollectionUtils.isNotEmpty(this.listeners)) {
            RuntimeException exception = null;
            for (ExporterListener listener : this.listeners) {
                if (listener == null) continue;
                try {
                    consumer.accept(listener);
                }
                catch (RuntimeException t) {
                    logger.error("0-9", "", "", t.getMessage(), (Throwable)t);
                    exception = t;
                }
            }
            if (exception != null) {
                throw exception;
            }
        }
    }
}

