/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.call;

import java.util.Map;
import org.apache.dubbo.common.stream.StreamObserver;
import org.apache.dubbo.rpc.TriRpcStatus;
import org.apache.dubbo.rpc.protocol.tri.call.ClientCall;

public class ObserverToClientCallListenerAdapter
implements ClientCall.Listener {
    private final StreamObserver<Object> delegate;
    private ClientCall call;

    public ObserverToClientCallListenerAdapter(StreamObserver<Object> delegate) {
        this.delegate = delegate;
    }

    @Override
    public void onMessage(Object message) {
        this.delegate.onNext(message);
        if (this.call.isAutoRequestN()) {
            this.call.requestN(1);
        }
    }

    @Override
    public void onClose(TriRpcStatus status, Map<String, Object> trailers) {
        if (status.isOk()) {
            this.delegate.onCompleted();
        } else {
            this.delegate.onError((Throwable)status.asException());
        }
    }

    @Override
    public void onStart(ClientCall call) {
        this.call = call;
        if (call.isAutoRequestN()) {
            call.requestN(1);
        }
    }
}

