/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.call;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Executor;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.TriRpcStatus;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.MethodDescriptor;
import org.apache.dubbo.rpc.model.ServiceDescriptor;
import org.apache.dubbo.rpc.model.StubMethodDescriptor;
import org.apache.dubbo.rpc.protocol.tri.call.ServerCall;
import org.apache.dubbo.rpc.protocol.tri.stream.ServerStream;
import org.apache.dubbo.rpc.protocol.tri.stream.ServerStreamListener;
import org.apache.dubbo.rpc.stub.StubSuppliers;

public class StubServerCall
extends ServerCall {
    private final StubMethodDescriptor methodDescriptor;

    public StubServerCall(Invoker<?> invoker, ServerStream serverStream, FrameworkModel frameworkModel, String acceptEncoding, String serviceName, String methodName, Executor executor) {
        super(invoker, serverStream, frameworkModel, StubServerCall.getServiceDescriptor(invoker.getUrl(), serviceName), acceptEncoding, serviceName, methodName, executor);
        this.methodDescriptor = (StubMethodDescriptor)this.serviceDescriptor.getMethods(methodName).get(0);
        this.packableMethod = this.methodDescriptor;
    }

    private static ServiceDescriptor getServiceDescriptor(URL url, String serviceName) {
        ServiceDescriptor serviceDescriptor = url.getServiceModel() != null ? url.getServiceModel().getServiceModel() : StubSuppliers.getServiceDescriptor((String)serviceName);
        return serviceDescriptor;
    }

    @Override
    public ServerStreamListener doStartCall(Map<String, Object> metadata) {
        RpcInvocation invocation = this.buildInvocation(metadata, (MethodDescriptor)this.methodDescriptor);
        this.listener = this.startInternalCall(invocation, (MethodDescriptor)this.methodDescriptor, this.invoker);
        if (this.listener == null) {
            return null;
        }
        return new ServerStreamListenerImpl();
    }

    class ServerStreamListenerImpl
    extends ServerCall.ServerStreamListenerBase {
        ServerStreamListenerImpl() {
        }

        @Override
        public void complete() {
            StubServerCall.this.listener.onComplete();
        }

        @Override
        public void cancel(TriRpcStatus status) {
            StubServerCall.this.listener.onCancel(status.description);
        }

        @Override
        protected void doOnMessage(byte[] message) throws IOException, ClassNotFoundException {
            Object request = StubServerCall.this.methodDescriptor.parseRequest(message);
            StubServerCall.this.listener.onMessage(request);
        }
    }
}

