/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.call;

import java.util.Map;
import org.apache.dubbo.rpc.AppResponse;
import org.apache.dubbo.rpc.TriRpcStatus;
import org.apache.dubbo.rpc.protocol.tri.DeadlineFuture;
import org.apache.dubbo.rpc.protocol.tri.call.ClientCall;

public class UnaryClientCallListener
implements ClientCall.Listener {
    private final DeadlineFuture future;
    private Object appResponse;

    public UnaryClientCallListener(DeadlineFuture deadlineFuture) {
        this.future = deadlineFuture;
    }

    @Override
    public void onMessage(Object message) {
        this.appResponse = message;
    }

    @Override
    public void onClose(TriRpcStatus status, Map<String, Object> trailers) {
        AppResponse result = new AppResponse();
        result.setObjectAttachments(trailers);
        if (status.isOk()) {
            result.setValue(this.appResponse);
        } else {
            result.setException((Throwable)status.asException());
        }
        this.future.received(status, result);
    }

    @Override
    public void onStart(ClientCall call) {
        this.future.addTimeoutListener(() -> call.cancel("client timeout", null));
        call.requestN(2);
    }
}

