/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.observer;

import org.apache.dubbo.rpc.protocol.tri.CancelableStreamObserver;
import org.apache.dubbo.rpc.protocol.tri.ClientStreamObserver;
import org.apache.dubbo.rpc.protocol.tri.call.ClientCall;

public class ClientCallToObserverAdapter<T>
extends CancelableStreamObserver<T>
implements ClientStreamObserver<T> {
    private final ClientCall call;
    private boolean terminated;

    public ClientCallToObserverAdapter(ClientCall call) {
        this.call = call;
    }

    public boolean isAutoRequestEnabled() {
        return this.call.isAutoRequestN();
    }

    public void onNext(Object data) {
        if (this.terminated) {
            throw new IllegalStateException("Stream observer has been terminated, no more data is allowed");
        }
        this.call.sendMessage(data);
    }

    public void onError(Throwable throwable) {
        this.call.cancel(null, throwable);
        this.terminated = true;
    }

    public void onCompleted() {
        if (this.terminated) {
            return;
        }
        this.call.halfClose();
        this.terminated = true;
    }

    @Override
    public void cancel(Throwable throwable) {
        this.call.cancel("Canceled by app ", throwable);
        this.terminated = true;
    }

    @Override
    public void setCompression(String compression) {
        this.call.setCompression(compression);
    }

    @Override
    public void request(int count) {
        this.call.requestN(count);
    }

    @Override
    public void disableAutoRequest() {
        this.call.setAutoRequestN(false);
    }
}

